/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.caching;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.cocoon.pipeline.caching.AbstractCacheKey;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.util.MurmurHashCodeBuilder;
import org.apache.cocoon.pipeline.util.StringRepresentation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompoundCacheKey
extends AbstractCacheKey {
    private static final long serialVersionUID = 1L;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final List<CacheKey> cacheKeys = new LinkedList<CacheKey>();

    public void addCacheKey(CacheKey cacheKey) {
        this.cacheKeys.add(cacheKey);
    }

    public boolean equals(Object obj) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Comparing two cache keys: ");
            this.logger.debug((Object)("  this=" + this));
            this.logger.debug((Object)("  other=" + obj));
        }
        if (!(obj instanceof CompoundCacheKey)) {
            return false;
        }
        CompoundCacheKey other = (CompoundCacheKey)obj;
        if (this.cacheKeys.size() != other.cacheKeys.size()) {
            return false;
        }
        Iterator<CacheKey> myIterator = this.cacheKeys.iterator();
        Iterator<CacheKey> otherIterator = other.cacheKeys.iterator();
        while (myIterator.hasNext()) {
            CacheKey myCacheKey = myIterator.next();
            CacheKey otherCacheKey = otherIterator.next();
            if (myCacheKey != null && myCacheKey.equals(otherCacheKey)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Cache keys are not equal: ");
                this.logger.debug((Object)("  myCacheKey=" + myCacheKey));
                this.logger.debug((Object)("  otherCacheKey=" + otherCacheKey));
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        MurmurHashCodeBuilder murmurHashCodeBuilder = new MurmurHashCodeBuilder();
        for (CacheKey cacheKey : this.cacheKeys) {
            murmurHashCodeBuilder.append(cacheKey.hashCode());
        }
        return murmurHashCodeBuilder.toHashCode();
    }

    public boolean isValid(CacheKey cacheKey) {
        if (!this.equals(cacheKey)) {
            return false;
        }
        CompoundCacheKey other = (CompoundCacheKey)cacheKey;
        Iterator<CacheKey> myIterator = this.cacheKeys.iterator();
        Iterator<CacheKey> otherIterator = other.cacheKeys.iterator();
        while (myIterator.hasNext()) {
            CacheKey otherCacheKey;
            CacheKey myCacheKey = myIterator.next();
            if (myCacheKey.isValid(otherCacheKey = otherIterator.next())) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Cache key is not valid: ");
                this.logger.debug((Object)("  myCacheKey=" + myCacheKey));
                this.logger.debug((Object)("  otherCacheKey=" + otherCacheKey));
            }
            return false;
        }
        return true;
    }

    public long getLastModified() {
        long lastModified = 0L;
        for (CacheKey eachKey : this.cacheKeys) {
            long eachLastModified = eachKey.getLastModified();
            if (eachLastModified == -1L) {
                return -1L;
            }
            if (eachLastModified <= lastModified) continue;
            lastModified = eachLastModified;
        }
        return lastModified;
    }

    public String toString() {
        return StringRepresentation.buildString(this, "key=" + this.cacheKeys);
    }
}

