/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.caching;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.CacheRefreshJob;
import org.apache.cocoon.pipeline.caching.CacheRefreshManager;
import org.apache.cocoon.pipeline.util.StringRepresentation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheRefreshManagerImpl
implements CacheRefreshManager {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final int threadPoolSize = 50;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);
    private final List<CacheKey> pendingCacheKeys = Collections.synchronizedList(new LinkedList());

    public void refreshCacheValue(CacheKey cacheKey, CacheRefreshJob cacheRefreshJob) {
        if (this.pendingCacheKeys.contains(cacheKey)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Refreshing of this cache key is already scheduled: " + cacheKey));
            }
            return;
        }
        this.pendingCacheKeys.add(cacheKey);
        this.executorService.execute(new RefreshWorker(cacheKey, cacheRefreshJob));
    }

    protected void executeCacheRefreshJob(CacheRefreshJob cacheRefreshJob, CacheKey cacheKey) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Execute cache refresh job for " + cacheRefreshJob));
        }
        cacheRefreshJob.refresh(cacheKey);
        this.pendingCacheKeys.remove(cacheKey);
    }

    public String toString() {
        return StringRepresentation.buildString(this, "executerService=" + this.executorService, "threadPoolSize=50");
    }

    private class RefreshWorker
    implements Runnable {
        private final CacheKey cacheKey;
        private final CacheRefreshJob cacheRefreshJob;

        public RefreshWorker(CacheKey cacheKey, CacheRefreshJob cacheRefreshJob) {
            this.cacheKey = cacheKey;
            this.cacheRefreshJob = cacheRefreshJob;
        }

        public void run() {
            CacheRefreshManagerImpl.this.executeCacheRefreshJob(this.cacheRefreshJob, this.cacheKey);
        }
    }
}

