/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.cocoon.pipeline.AbstractPipeline;
import org.apache.cocoon.pipeline.caching.Cache;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.CacheValue;
import org.apache.cocoon.pipeline.caching.CachingOutputStream;
import org.apache.cocoon.pipeline.caching.CompleteCacheValue;
import org.apache.cocoon.pipeline.caching.CompoundCacheKey;
import org.apache.cocoon.pipeline.caching.ExpiresCacheKey;
import org.apache.cocoon.pipeline.caching.InvalidCacheKey;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.pipeline.component.PipelineComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingPipeline<T extends PipelineComponent>
extends AbstractPipeline<T> {
    protected Cache cache;
    protected CacheKey cacheKey;
    protected CachingOutputStream cachingOutputStream;
    private String expires;
    private Serializable expiresCacheKey;
    private String jmxGroupName;
    private final Log logger = LogFactory.getLog(this.getClass());

    public CacheKey constructCacheKey() {
        CompoundCacheKey result = new CompoundCacheKey();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating " + result + ": "));
        }
        for (PipelineComponent pipelineComponent : this.getComponents()) {
            CachingPipelineComponent cachablePipelineComponent;
            CacheKey cacheKey;
            if (pipelineComponent instanceof CachingPipelineComponent && (cacheKey = (cachablePipelineComponent = (CachingPipelineComponent)((Object)pipelineComponent)).constructCacheKey()) != null) {
                result.addCacheKey(cacheKey);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("  ~ adding " + cacheKey + " for component " + pipelineComponent));
                continue;
            }
            if (this.expires != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("  ~ adding " + ExpiresCacheKey.class.getSimpleName() + " for component: " + pipelineComponent + " (the component doesn't support caching " + "but expires caching is activated)"));
                }
                return new ExpiresCacheKey(new InvalidCacheKey(this.expiresCacheKey), this.expires);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("  ~ no caching: " + pipelineComponent));
                this.logger.debug((Object)"Aborting cache key construction");
            }
            return null;
        }
        if (this.expires != null) {
            ExpiresCacheKey expiresCacheKey = new ExpiresCacheKey(result, this.expires);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating  " + expiresCacheKey + " for pipeline " + this));
            }
            return expiresCacheKey;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating  " + result + " for pipeline " + this));
        }
        return result;
    }

    @Override
    public void execute() throws Exception {
        CacheValue cachedValue;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Used cache: " + this.cache));
        }
        if (this.isCacheKeyValid(cachedValue = this.getCachedValue(this.cacheKey))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Write cache value to output stream: " + cachedValue));
            }
            cachedValue.writeTo(this.cachingOutputStream.getOutputStream());
            return;
        }
        this.invokeStarter();
        CompleteCacheValue cacheValue = new CompleteCacheValue(this.cachingOutputStream.getContent(), this.cacheKey);
        this.setCachedValue(this.cacheKey, cacheValue);
    }

    public CacheKey getCacheKey() {
        return this.cacheKey;
    }

    public String getExpires() {
        return this.expires;
    }

    @Override
    public long getLastModified() {
        if (this.cacheKey == null) {
            return -1L;
        }
        return this.cacheKey.getLastModified();
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public void setConfiguration(Map<String, ? extends Object> parameters) {
        this.expires = (String)parameters.get("expires");
        this.expiresCacheKey = (Serializable)parameters.get("expires-cache-key");
        this.jmxGroupName = (String)parameters.get("jmx-group-name");
        super.setConfiguration(parameters);
    }

    public void setExpires(String expires) {
        this.expires = expires;
    }

    public void setExpiresCacheKey(Serializable expiresCacheKey) {
        this.expiresCacheKey = expiresCacheKey;
    }

    @Override
    public void setup(OutputStream outputStream, Map<String, Object> parameters) {
        this.cachingOutputStream = new CachingOutputStream(outputStream);
        super.setup(this.cachingOutputStream, parameters);
        this.cacheKey = this.constructCacheKey();
    }

    protected CacheValue getCachedValue(CacheKey cacheKey) {
        if (cacheKey == null) {
            return null;
        }
        if (this.cache == null) {
            this.logger.warn((Object)"Caching pipeline has no cache configured. Falling back to non-caching behavior.");
            return null;
        }
        CacheValue cacheValue = this.cache.get(cacheKey, true);
        if (this.logger.isDebugEnabled()) {
            if (cacheValue != null) {
                this.logger.debug((Object)("Retrieved content from cache: " + cacheValue));
            } else {
                this.logger.debug((Object)("No cache value available for " + cacheKey));
            }
        }
        return cacheValue;
    }

    protected boolean isCacheKeyValid(CacheValue cachedValue) {
        return cachedValue != null && cachedValue.isValid(this.cacheKey);
    }

    protected void setCachedValue(CacheKey cacheKey, CacheValue cacheValue) {
        if (cacheKey == null) {
            return;
        }
        if (this.cache == null) {
            this.logger.warn((Object)"Caching pipeline has no cache configured. Falling back to non-caching behavior.");
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Putting result into pipeline cache: " + cacheValue + ")"));
        }
        cacheKey.setJmxGroupName(this.jmxGroupName);
        this.cache.put(cacheKey, cacheValue);
    }
}

