/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.optional.pipeline.components.sax.jaxb;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InMemoryLRUMarshallerCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CACHE_SIZE = 255;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int CACHE_CAPACITY = (int)Math.ceil(340.0) + 1;
    private static final InMemoryLRUMarshallerCache INSTANCE = new InMemoryLRUMarshallerCache();
    private final Map<Class<?>, JAXBContext> data = new LinkedHashMap<Class<?>, JAXBContext>(CACHE_CAPACITY, 0.75f){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Class<?>, JAXBContext> eldest) {
            return this.size() > 255;
        }
    };

    public static InMemoryLRUMarshallerCache getInstance() {
        return INSTANCE;
    }

    private InMemoryLRUMarshallerCache() {
    }

    public synchronized Marshaller getMarshaller(Class<?> clazz) throws JAXBException {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter 'clazz' must not be null");
        }
        JAXBContext jaxbContext = null;
        if (this.data.containsKey(clazz)) {
            jaxbContext = this.data.get(clazz);
        } else {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            this.data.put(clazz, jaxbContext);
        }
        return jaxbContext.createMarshaller();
    }
}

