/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.optional.pipeline.components.sax.fop;

import java.io.OutputStream;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.SimpleCacheKey;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.pipeline.util.StringRepresentation;
import org.apache.cocoon.sax.AbstractSAXSerializer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.xml.sax.helpers.DefaultHandler;

public class FopSerializer
extends AbstractSAXSerializer
implements CachingPipelineComponent {
    private static final FopFactory FOP_FACTORY = FopFactory.newInstance();
    private String outputFormat;

    public FopSerializer() {
        this("application/pdf");
    }

    public FopSerializer(String outputFormat) {
        if (outputFormat == null) {
            throw new IllegalArgumentException("The parameter 'outputFormat' mustn't be null.");
        }
        this.outputFormat = outputFormat;
    }

    public void setOutputStream(OutputStream outputStream) {
        try {
            Fop fop = FOP_FACTORY.newFop(this.outputFormat, outputStream);
            DefaultHandler contentHandler = fop.getDefaultHandler();
            this.setContentHandler(contentHandler);
        }
        catch (FOPException e) {
            throw new ProcessingException("Impossible to initialize FOPSerializer", (Throwable)e);
        }
    }

    public CacheKey constructCacheKey() {
        return new SimpleCacheKey();
    }

    public String toString() {
        return StringRepresentation.buildString((Object)((Object)this), (String[])new String[]{"outputFormat=" + this.outputFormat});
    }
}

