/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.util.Vector;

public class EnumerationFactory {
    private static Vector allObjects = new Vector(0, 1);
    private int pos = allObjects.size();
    private String image;

    public EnumerationFactory(String image) {
        this.image = image;
        allObjects.addElement(this);
    }

    public EnumerationFactory() {
        this("");
    }

    public boolean lt(EnumerationFactory e) {
        return this.getPos() < e.getPos();
    }

    public boolean le(EnumerationFactory e) {
        return this.getPos() <= e.getPos();
    }

    public boolean gt(EnumerationFactory e) {
        return this.getPos() > e.getPos();
    }

    public boolean ge(EnumerationFactory e) {
        return this.getPos() >= e.getPos();
    }

    public int getPos() {
        return this.pos;
    }

    public static EnumerationFactory getVal(int value) {
        return (EnumerationFactory)allObjects.elementAt(value);
    }

    public static EnumerationFactory getFirst() {
        return EnumerationFactory.getVal(0);
    }

    public static EnumerationFactory getLast() {
        return EnumerationFactory.getVal(allObjects.size() - 1);
    }

    public EnumerationFactory getNext() {
        return EnumerationFactory.getVal(this.getPos() + 1);
    }

    public EnumerationFactory getPrev() {
        return EnumerationFactory.getVal(this.getPos() - 1);
    }

    public String toString() {
        return this.image;
    }

    public static EnumerationFactory getObject(String image) {
        for (int i = 0; i < allObjects.size(); ++i) {
            EnumerationFactory found = (EnumerationFactory)allObjects.elementAt(i);
            if (!found.toString().equals(image)) continue;
            return found;
        }
        return null;
    }
}

