/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.cocoon.servletservice.ServletConnection;
import org.apache.cocoon.servletservice.util.ServletServiceRequest;
import org.apache.cocoon.servletservice.util.ServletServiceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractServletConnection
implements ServletConnection {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected ServletServiceRequest request;
    protected ServletServiceResponse response;
    protected ServletContext context;
    protected boolean connected;
    protected ByteArrayOutputStream requestBody;
    protected InputStream responseBody;
    protected URI uri;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException, ServletException {
        if (this.connected) {
            return;
        }
        this.request.setContext(this.context);
        if (this.requestBody != null) {
            this.request.setMethod("POST");
            this.request.setInputStream(new ByteArrayInputStream(this.requestBody.toByteArray()));
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.response.setOutputStream(os);
        try {
            this.performConnect();
            this.response.flushBuffer();
            this.responseBody = new ByteArrayInputStream(os.toByteArray());
        }
        finally {
            os.close();
        }
        this.connected = true;
    }

    protected abstract void performConnect() throws ServletException, IOException;

    public InputStream getInputStream() throws IOException, ServletException {
        this.connect();
        return this.responseBody;
    }

    public void setIfModifiedSince(long ifmodifiedsince) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.request.setDateHeader("If-Modified-Since", ifmodifiedsince);
    }

    public long getLastModified() {
        return this.getDateHeader("Last-Modified", 0L);
    }

    public String getContentType() {
        return this.getHeaderField("Content-Type");
    }

    public long getDateHeader(String name, long defaultValue) {
        try {
            return this.response.getDateHeader(name);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Exception while reading the response header '" + name + "'."));
            return defaultValue;
        }
    }

    public String getHeaderField(String name) {
        try {
            this.connect();
        }
        catch (Exception e) {
            this.logger.warn((Object)("Exception while reading the response header '" + name + "'."));
            return null;
        }
        return this.response.getHeader(name);
    }

    public long getHeaderFieldDate(String name, long defaultValue) {
        try {
            return this.response.getDateHeader(name);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Exception while reading the response header '" + name + "'."));
            return defaultValue;
        }
    }

    public Map getHeaders() {
        try {
            this.connect();
        }
        catch (Exception e) {
            this.logger.warn((Object)"Exception while reading the response headers.");
            return null;
        }
        return this.response.getHeaders();
    }

    public int getResponseCode() throws IOException {
        try {
            this.connect();
        }
        catch (ServletException e) {
            throw new IOException("Could not get response status code");
        }
        return this.response.getStatus();
    }

    public OutputStream getOutputStream() throws IllegalStateException {
        if (this.connected) {
            throw new IllegalStateException("You cannot write to the connection already connected.");
        }
        if (this.requestBody == null) {
            this.requestBody = new ByteArrayOutputStream();
        }
        return this.requestBody;
    }

    public URI getURI() {
        return this.uri;
    }

    protected static class NoServletContextAvailableException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NoServletContextAvailableException(String message) {
            super(message);
        }
    }
}

