/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;
import org.xml.sax.SAXException;

public class DatabaseReader
extends ServiceableReader
implements Configurable,
Disposable,
CacheableProcessingComponent {
    private DataSourceComponent dataSourceComponent;
    private DataSource dataSource;
    private int typeColumn;
    private boolean defaultCache = true;
    private Connection connection;
    private PreparedStatement statement;
    private ResultSet resultSet;
    private InputStream resource;
    private String mimeType;
    private long lastModified = System.currentTimeMillis();
    private boolean doCommit;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.defaultCache = conf.getChild("invalidate").getValue("never").equals("always");
        if (this.dataSource == null) {
            String datasourceName = conf.getChild("use-connection").getValue();
            try {
                this.dataSourceComponent = (DataSourceComponent)this.manager.lookup(DataSourceComponent.ROLE + '/' + datasourceName);
            }
            catch (ServiceException e) {
                throw new ConfigurationException("Datasource '" + datasourceName + "' is not available.", (Throwable)e);
            }
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            this.connection = this.dataSource != null ? this.dataSource.getConnection() : this.dataSourceComponent.getConnection();
            if (this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(false);
            }
            this.statement = this.connection.prepareStatement(this.getQuery());
            this.statement.setString(1, this.source);
            this.resultSet = this.statement.executeQuery();
            if (!this.resultSet.next()) {
                throw new ResourceNotFoundException("There is no resource with that key");
            }
            Response response = ObjectModelHelper.getResponse((Map)objectModel);
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            if (this.modifiedSince(this.resultSet, request, response)) {
                this.resource = this.resultSet.getBinaryStream(1);
                if (this.resource == null) {
                    throw new ResourceNotFoundException("There is no resource with that key");
                }
                if (this.typeColumn != 0) {
                    this.mimeType = this.resultSet.getString(this.typeColumn);
                }
            }
            this.doCommit = true;
        }
        catch (Exception e) {
            this.doCommit = false;
            throw new ResourceNotFoundException("DatabaseReader error:", (Throwable)e);
        }
    }

    public void generate() throws ProcessingException, SAXException, IOException {
        try {
            Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
            this.serialize(response);
        }
        catch (IOException e) {
            this.getLogger().warn((Object)"Assuming client reset stream");
            this.doCommit = false;
        }
        catch (Exception e) {
            this.doCommit = false;
            throw new ResourceNotFoundException("DatabaseReader error:", (Throwable)e);
        }
    }

    protected String getQuery() throws ProcessingException {
        String table = this.parameters.getParameter("table", null);
        String column = this.parameters.getParameter("image", null);
        String key = this.parameters.getParameter("key", null);
        String where = this.parameters.getParameter("where", null);
        String orderBy = this.parameters.getParameter("order-by", null);
        String typeColumn = this.parameters.getParameter("type-column", null);
        if (table == null || column == null || key == null) {
            throw new ProcessingException("We are missing a required parameter.  Please include 'table', 'image', and 'key'");
        }
        String date = this.parameters.getParameter("last-modified", null);
        StringBuffer query = new StringBuffer("SELECT ");
        int columnNo = 1;
        query.append(column);
        ++columnNo;
        if (date != null) {
            query.append(", ").append(date);
            ++columnNo;
        }
        if (null != orderBy) {
            query.append(", ");
            if (orderBy.endsWith(" DESC")) {
                query.append(orderBy.substring(0, orderBy.length() - 5));
            } else {
                query.append(orderBy);
            }
            ++columnNo;
        }
        if (null != typeColumn) {
            query.append(", ").append(typeColumn);
            this.typeColumn = columnNo;
        }
        query.append(" FROM ").append(table);
        query.append(" WHERE ").append(key).append(" = ?");
        if (null != where) {
            query.append(" AND ").append(where);
        }
        if (null != orderBy) {
            query.append(" ORDER BY ").append(orderBy);
        }
        return query.toString();
    }

    protected boolean modifiedSince(ResultSet set, Request request, Response response) throws SQLException {
        String lastModified = this.parameters.getParameter("last-modified", null);
        if (lastModified != null) {
            Timestamp modified = set.getTimestamp(lastModified, null);
            if (null != modified) {
                this.lastModified = modified.getTime();
            }
            response.setDateHeader("Last-Modified", this.lastModified);
            return this.lastModified > request.getDateHeader("if-modified-since");
        }
        return true;
    }

    public void serialize(Response response) throws IOException, SQLException {
        int length;
        if (this.resource == null) {
            throw new SQLException("The Blob is empty!");
        }
        BufferedInputStream is = new BufferedInputStream(this.resource);
        long expires = this.parameters.getParameterAsInteger("expires", -1);
        if (expires > 0L) {
            response.setDateHeader("Expires", System.currentTimeMillis() + expires);
        }
        response.setHeader("Accept-Ranges", "bytes");
        byte[] buffer = new byte[8192];
        while ((length = ((InputStream)is).read(buffer)) > -1) {
            this.out.write(buffer, 0, length);
        }
        ((InputStream)is).close();
        this.out.flush();
    }

    public Serializable getKey() {
        return this.source;
    }

    public SourceValidity getValidity() {
        if (this.lastModified > 0L) {
            return new TimeStampValidity(this.lastModified);
        }
        if (this.defaultCache) {
            return NOPValidity.SHARED_INSTANCE;
        }
        return null;
    }

    public void recycle() {
        super.recycle();
        this.resource = null;
        this.lastModified = 0L;
        this.mimeType = null;
        this.typeColumn = 0;
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.resultSet = null;
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.statement = null;
        }
        if (this.connection != null) {
            try {
                if (this.doCommit) {
                    this.connection.commit();
                } else {
                    this.connection.rollback();
                }
            }
            catch (SQLException e) {
                this.getLogger().warn((Object)"Could not commit or rollback connection", (Throwable)e);
            }
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    public void dispose() {
        this.recycle();
        if (this.manager != null) {
            this.manager.release((Object)this.dataSourceComponent);
            this.dataSourceComponent = null;
            this.manager = null;
        }
    }

    public String getMimeType() {
        if (this.mimeType != null) {
            return this.mimeType;
        }
        return this.parameters.getParameter("content-type", super.getMimeType());
    }
}

