/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.databases.ibatis;

import com.ibatis.sqlmap.engine.datasource.DataSourceFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.internal.EnvironmentHelper;

public class ExcaliburDataSourceFactory
implements DataSourceFactory {
    protected DataSourceComponent datasource;

    public DataSource getDataSource() {
        return new DataSourceWrapper(this.datasource);
    }

    public void initialize(Map values) {
        String connection = (String)values.get("connection");
        if (connection == null) {
            throw new RuntimeException("Connection configuration is missing for " + this.getClass().getName() + "." + " Have a look at the iBatis sqlMapConfig and check the 'connection' property for the data source.");
        }
        ServiceManager manager = EnvironmentHelper.getSitemapServiceManager();
        if (manager == null) {
            throw new RuntimeException("Cocoon sitemap service manager is not available for " + this.getClass().getName() + "." + " Make sure that you're initializing iBatis during an active request and not on startup.");
        }
        try {
            this.datasource = (DataSourceComponent)manager.lookup(DataSourceComponent.ROLE + '/' + connection);
        }
        catch (ServiceException e) {
            throw new CascadingRuntimeException("Unable to lookup data source with name " + connection + "." + " Check the cocoon.xconf and the iBatis sqlMapConfig.", (Throwable)e);
        }
    }

    protected static final class DataSourceWrapper
    implements DataSource {
        protected final DataSourceComponent datasource;
        protected PrintWriter writer = new PrintWriter(System.out);
        protected int timeout = 0;

        public DataSourceWrapper(DataSourceComponent d) {
            this.datasource = d;
        }

        public Connection getConnection() throws SQLException {
            return this.datasource.getConnection();
        }

        public Connection getConnection(String username, String password) throws SQLException {
            return null;
        }

        public int getLoginTimeout() throws SQLException {
            return this.timeout;
        }

        public PrintWriter getLogWriter() throws SQLException {
            return this.writer;
        }

        public void setLoginTimeout(int seconds) throws SQLException {
            this.timeout = seconds;
        }

        public void setLogWriter(PrintWriter out) throws SQLException {
            this.writer = out;
        }

        public Object unwrap(Class iface) throws SQLException {
            return null;
        }

        public boolean isWrapperFor(Class iface) throws SQLException {
            return false;
        }
    }
}

