/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractMetaModule;
import org.apache.cocoon.util.JDBCTypeConversions;

public class CollectionMetaModule
extends AbstractMetaModule
implements ThreadSafe {
    protected Configuration memberConf;

    public void configure(Configuration config) throws ConfigurationException {
        this.memberConf = config.getChild("member");
        this.inputConf = config.getChild("input-module");
        this.defaultInput = this.inputConf.getAttribute("name", this.defaultInput);
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized) {
            this.lazy_initialize();
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)"No input module given. FAILING");
            }
            return null;
        }
        Configuration mConf = this.memberConf;
        Configuration inputConfig = null;
        String inputName = null;
        if (modeConf != null) {
            mConf = modeConf.getChild("member");
            inputName = modeConf.getChild("input-module").getAttribute("name", null);
            if (inputName != null) {
                inputConfig = modeConf.getChild("input-module");
            }
        }
        String jType = mConf.getAttribute("type", "string");
        String pName = mConf.getAttribute("name");
        int index = pName.indexOf("*");
        if (index > -1) {
            String prefix = index > 0 ? pName.substring(0, index) : null;
            String suffix = index < pName.length() - 1 ? pName.substring(index + 1, pName.length()) : null;
            pName = prefix + name + suffix;
        }
        this.getLogger().debug((Object)("jType " + jType));
        Object[] values = this.getValues(pName, objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig);
        Object[] objects = null;
        if (values != null) {
            objects = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                objects[i] = JDBCTypeConversions.convert(value, jType);
            }
        }
        return objects;
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        Iterator names;
        if (!this.initialized) {
            this.lazy_initialize();
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)"No input module given. FAILING");
            }
            return null;
        }
        Configuration mConf = this.memberConf;
        Configuration inputConfig = null;
        String inputName = null;
        if (modeConf != null) {
            mConf = modeConf.getChild("member");
            inputName = modeConf.getChild("input-module").getAttribute("name", null);
            if (inputName != null) {
                inputConfig = modeConf.getChild("input-module");
            }
        }
        if ((names = this.getNames(objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, inputConfig)) != null) {
            TreeSet<String> matchset = new TreeSet<String>();
            String pName = mConf.getAttribute("name");
            int index = pName.indexOf("*");
            if (index > -1) {
                String suffix;
                String prefix = index > 0 ? pName.substring(0, index) : null;
                String string = suffix = index < pName.length() - 1 ? pName.substring(index + 1, pName.length()) : null;
                while (names.hasNext()) {
                    String name = (String)names.next();
                    if (!name.startsWith(prefix) || !name.endsWith(suffix)) continue;
                    String wildcard = name.substring(prefix.length());
                    wildcard = wildcard.substring(0, wildcard.length() - suffix.length());
                    matchset.add(wildcard);
                }
            } else {
                boolean done = false;
                while (!done && names.hasNext()) {
                    String name = (String)names.next();
                    if (!name.equals(pName)) continue;
                    matchset.add(pName);
                    done = true;
                }
            }
            return matchset.iterator();
        }
        return null;
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Iterator names = this.getAttributeNames(modeConf, objectModel);
        ArrayList<Object> values = new ArrayList<Object>();
        while (names.hasNext()) {
            values.add(this.getAttribute((String)names.next(), modeConf, objectModel));
        }
        return values.toArray();
    }
}

