/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.CascadingIOException;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceValidity;

public class BlobSource
extends AbstractLogEnabled
implements Source,
Serviceable {
    private static final String URL_PREFIX = "blob:/";
    private static final int URL_PREFIX_LEN = "blob:/".length();
    private ServiceManager manager;
    private String systemId;
    private String datasourceName;
    private String tableName;
    private String columnName;
    private String condition;

    public BlobSource(String url) throws MalformedURLException {
        this.systemId = url;
        int start = URL_PREFIX_LEN;
        int end = url.indexOf(47, start);
        if (end == -1) {
            throw new MalformedURLException("Malformed blob source (cannot find datasource) : " + url);
        }
        this.datasourceName = url.substring(start, end);
        start = end + 1;
        if ((end = url.indexOf(47, start)) == -1) {
            throw new MalformedURLException("Malformed blob source (cannot find table name) : " + url);
        }
        this.tableName = url.substring(start, end);
        start = end + 1;
        if ((end = url.indexOf(91, start)) == -1) {
            this.columnName = url.substring(start);
        } else {
            this.columnName = url.substring(start, end);
            start = end + 1;
            end = url.length() - 1;
            if (url.charAt(end) != ']') {
                throw new MalformedURLException("Malformed url for a blob source (cannot find condition) : " + url);
            }
            this.condition = url.substring(start, end);
        }
    }

    public void service(ServiceManager manager) {
        this.manager = manager;
    }

    public String getScheme() {
        return URL_PREFIX;
    }

    public String getURI() {
        return this.systemId;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInputStream() throws IOException, SourceException {
        block38: {
            block33: {
                block37: {
                    block32: {
                        block36: {
                            block31: {
                                block35: {
                                    block30: {
                                        if (this.getLogger().isDebugEnabled()) {
                                            this.getLogger().debug("Opening stream for datasource " + this.datasourceName + ", table " + this.tableName + ", column " + this.columnName + (this.condition == null ? ", no condition" : ", condition " + this.condition));
                                        }
                                        conn = null;
                                        stmt = null;
                                        try {
                                            try {
                                                conn = this.getConnection();
                                                stmt = conn.createStatement();
                                                selectBuf = new StringBuffer("SELECT ").append(this.columnName).append(" FROM ").append(this.tableName);
                                                if (this.condition != null) {
                                                    selectBuf.append(" WHERE ").append(this.condition);
                                                }
                                                select = selectBuf.toString();
                                                if (this.getLogger().isDebugEnabled()) {
                                                    this.getLogger().debug("Executing statement " + select);
                                                }
                                                if (!(rs = stmt.executeQuery(select)).next()) {
                                                    throw new SourceNotFoundException("Source not found.");
                                                }
                                                colType = rs.getMetaData().getColumnType(1);
                                                switch (colType) {
                                                    case 2004: {
                                                        blob = rs.getBlob(1);
                                                        if (blob == null) break;
                                                        var8_10 = new JDBCInputStream(blob.getBinaryStream(), conn);
                                                        var12_12 = null;
                                                        break block30;
                                                    }
                                                    case 2005: {
                                                        clob = rs.getClob(1);
                                                        if (clob == null) break;
                                                        var9_22 = new JDBCInputStream(clob.getAsciiStream(), conn);
                                                        break block31;
                                                    }
                                                    default: {
                                                        value = rs.getString(1);
                                                        if (value == null) break;
                                                        var10_24 = new ByteArrayInputStream(value.getBytes());
                                                        break block32;
                                                    }
                                                }
                                                var7_9 = new ByteArrayInputStream(new byte[0]);
                                                break block33;
                                            }
                                            catch (SQLException e) {
                                                msg = "Cannot retrieve content from " + this.systemId;
                                                this.getLogger().error(msg, (Throwable)e);
                                                throw new SourceException(msg, (Throwable)e);
                                            }
                                        }
                                        catch (Throwable var11_25) {
                                            var12_16 = null;
                                            try {
                                                if (stmt != null) {
                                                    stmt.close();
                                                }
                                            }
                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                            try {
                                                if (conn == null) throw var11_25;
                                                conn.close();
                                                throw var11_25;
                                            }
                                            catch (SQLException e) {
                                                throw var11_25;
                                            }
                                        }
                                    }
                                    ** try [egrp 2[TRYBLOCK] [9 : 481->494)] { 
lbl64:
                                    // 1 sources

                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                    break block35;
lbl67:
                                    // 1 sources

                                    catch (SQLException e) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [10 : 496->509)] { 
lbl71:
                                // 1 sources

                                if (conn == null) return var8_10;
                                conn.close();
                                return var8_10;
lbl74:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                                return var8_10;
                            }
                            var12_13 = null;
                            ** try [egrp 2[TRYBLOCK] [9 : 481->494)] { 
lbl80:
                            // 1 sources

                            if (stmt != null) {
                                stmt.close();
                            }
                            break block36;
lbl83:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [10 : 496->509)] { 
lbl87:
                        // 1 sources

                        if (conn == null) return var9_22;
                        conn.close();
                        return var9_22;
lbl90:
                        // 1 sources

                        catch (SQLException e) {
                            // empty catch block
                        }
                        return var9_22;
                    }
                    var12_14 = null;
                    ** try [egrp 2[TRYBLOCK] [9 : 481->494)] { 
lbl96:
                    // 1 sources

                    if (stmt != null) {
                        stmt.close();
                    }
                    break block37;
lbl99:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                ** try [egrp 3[TRYBLOCK] [10 : 496->509)] { 
lbl103:
                // 1 sources

                if (conn == null) return var10_24;
                conn.close();
                return var10_24;
lbl106:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
                return var10_24;
            }
            var12_15 = null;
            ** try [egrp 2[TRYBLOCK] [9 : 481->494)] { 
lbl112:
            // 1 sources

            if (stmt != null) {
                stmt.close();
            }
            break block38;
lbl115:
            // 1 sources

            catch (SQLException e) {
                // empty catch block
            }
        }
        try {}
        catch (SQLException e) {
            // empty catch block
            return var7_9;
        }
        if (conn == null) return var7_9;
        conn.close();
        return var7_9;
    }

    public SourceValidity getValidity() {
        return null;
    }

    public void refresh() {
    }

    public boolean exists() {
        return true;
    }

    public String getMimeType() {
        return null;
    }

    public long getContentLength() {
        return -1L;
    }

    public long getLastModified() {
        return 0L;
    }

    public String getParameter(String name) {
        return null;
    }

    public long getParameterAsLong(String name) {
        return 0L;
    }

    public Iterator getParameterNames() {
        return new EmptyIterator();
    }

    /*
     * Loose catch block
     */
    private Connection getConnection() throws SourceException {
        Connection e222;
        DataSourceComponent datasource;
        ServiceSelector selector;
        block8: {
            selector = null;
            datasource = null;
            try {
                selector = (ServiceSelector)this.manager.lookup(DataSourceComponent.ROLE + "Selector");
                datasource = (DataSourceComponent)selector.select((Object)this.datasourceName);
            }
            catch (Exception e222) {
                String msg = "Cannot get datasource '" + this.datasourceName + "'";
                this.getLogger().error(msg);
                throw new SourceException(msg, (Throwable)e222);
            }
            e222 = datasource.getConnection();
            if (datasource == null) break block8;
            selector.release((Object)datasource);
        }
        return e222;
        {
            catch (Exception e3) {
                try {
                    String msg = "Cannot get connection for datasource '" + this.datasourceName + "'";
                    this.getLogger().error(msg);
                    throw new SourceException(msg, (Throwable)e3);
                }
                catch (Throwable throwable) {
                    if (datasource != null) {
                        selector.release(datasource);
                    }
                    throw throwable;
                }
            }
        }
    }

    private class JDBCInputStream
    extends FilterInputStream {
        private Connection cnx;

        private void closeCnx() throws IOException {
            if (this.cnx != null) {
                try {
                    this.cnx.close();
                }
                catch (Exception e) {
                    String msg = "Error closing the connection for " + BlobSource.this.getURI();
                    BlobSource.this.getLogger().warn(msg, (Throwable)e);
                    throw new CascadingIOException(msg + " : " + e.getMessage(), (Throwable)e);
                }
                finally {
                    this.cnx = null;
                }
            }
        }

        public JDBCInputStream(InputStream stream, Connection cnx) {
            super(stream);
            this.cnx = cnx;
        }

        public int read() throws IOException {
            try {
                int result = this.in.read();
                if (result == -1) {
                    this.closeCnx();
                }
                return result;
            }
            catch (IOException e) {
                this.closeCnx();
                throw e;
            }
        }

        public int read(byte[] b) throws IOException {
            try {
                int result = this.in.read(b);
                if (result == -1) {
                    this.closeCnx();
                }
                return result;
            }
            catch (IOException e) {
                this.closeCnx();
                throw e;
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int result = this.in.read(b, off, len);
                if (result == -1) {
                    this.closeCnx();
                }
                return result;
            }
            catch (IOException e) {
                this.closeCnx();
                throw e;
            }
        }

        public void close() throws IOException {
            super.close();
            this.closeCnx();
        }
    }

    static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }
}

