/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.web.resources.yui;

import java.net.URL;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.clerezza.web.fileserver.BundlePathNode;
import org.apache.clerezza.web.fileserver.FileServer;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.commons.util.dirbrowser.PathNode;

@Path(value="/yui")
public class Yui {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private FileServer fileServer;

    protected void activate(ComponentContext context) {
        Bundle bundle = context.getBundleContext().getBundle();
        URL resourceDir = this.getClass().getResource("staticweb");
        BundlePathNode pathNode = new BundlePathNode(bundle, resourceDir.getPath());
        this.logger.debug("Initializing file server for {} ({})", (Object)resourceDir, (Object)resourceDir.getFile());
        this.fileServer = new FileServer((PathNode)pathNode);
    }

    @GET
    @Path(value="{path:.+}")
    public PathNode getStaticFile(@PathParam(value="path") String path) {
        this.logger.warn("Accessing deprecated path for yui2, use 2/{} instead.", (Object)path);
        return this.getYui2File(path);
    }

    @GET
    @Path(value="2/{path:.+}")
    public PathNode getYui2File(@PathParam(value="path") String path) {
        PathNode node = this.fileServer.getNode("2/" + path);
        this.logger.debug("Serving static {}", (Object)node);
        return node;
    }

    @GET
    @Path(value="3/{path:.+}")
    public PathNode getYui3File(@PathParam(value="path") String path) {
        PathNode node = this.fileServer.getNode("3/" + path);
        this.logger.debug("Serving static {}", (Object)node);
        return node;
    }
}

