/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.apache.clerezza.triaxrs.util.MediaTypeUtils;
import org.apache.clerezza.triaxrs.util.MultivaluedMapImpl;
import org.apache.clerezza.triaxrs.util.PathSegmentImpl;
import org.apache.clerezza.triaxrs.util.StringUtils;
import org.apache.clerezza.triaxrs.util.uri.UriEncoder;
import org.apache.clerezza.triaxrs.util.uri.UriPathNormalizer;

public class UriHelper {
    private UriHelper() {
    }

    public static String removeTrailingSlash(String uri) {
        if (uri != null && uri.length() > 0 && uri.lastIndexOf(47) == uri.length() - 1) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    public static String stripQueryString(String requestUri) {
        int idx;
        if (requestUri != null && (idx = requestUri.lastIndexOf(63)) != -1) {
            requestUri = requestUri.substring(0, idx);
            return UriHelper.removeTrailingSlash(requestUri);
        }
        return requestUri;
    }

    public static String getQueryString(String requestUri) {
        int idx;
        if (requestUri != null && (idx = requestUri.lastIndexOf(63)) != -1) {
            return requestUri.substring(idx + 1, requestUri.length());
        }
        return null;
    }

    public static String stripName(String requestUri) {
        int idx;
        if (requestUri != null && (idx = (requestUri = UriHelper.removeTrailingSlash(requestUri)).lastIndexOf(47)) != -1) {
            return requestUri.substring(0, idx);
        }
        return null;
    }

    public static String getNameFromPath(String uri) {
        if (uri != null) {
            uri = UriHelper.removeTrailingSlash(uri);
            return uri.substring(uri.lastIndexOf(47) + 1, uri.length());
        }
        return null;
    }

    public static String hidePassword(URI url) {
        if (url == null) {
            return null;
        }
        String ui = url.getRawUserInfo();
        if (ui == null) {
            return url.toString();
        }
        String str = url.toString();
        int pidx = str.indexOf(ui);
        if (pidx < 0) {
            return str;
        }
        return str.substring(0, pidx) + str.substring(pidx + ui.length() + 1);
    }

    public static String hidePassword(String url) {
        if (url == null) {
            return null;
        }
        return UriHelper.hidePassword(URI.create(url));
    }

    public static List<String> hidePassword(List<String> urls) {
        if (urls == null) {
            return urls;
        }
        ArrayList<String> ret = new ArrayList<String>(urls.size());
        for (String url : urls) {
            ret.add(UriHelper.hidePassword(url));
        }
        return ret;
    }

    public static String relativize(String basePath, String pathToRelativize) {
        int pos;
        String normalizeBasePath = UriHelper.removeStartSlash(UriPathNormalizer.normalize(basePath));
        String[] splitBase = StringUtils.fastSplit(normalizeBasePath, "/", false);
        String normalizedPathToRelativize = UriHelper.removeStartSlash(UriPathNormalizer.normalize(pathToRelativize));
        String[] splitPath = StringUtils.fastSplit(normalizedPathToRelativize, "/", false);
        for (pos = 0; pos < splitBase.length && pos < splitPath.length && splitBase[pos].equals(splitPath[pos]); ++pos) {
        }
        StringBuilder result = new StringBuilder();
        if (pos == splitBase.length && !normalizeBasePath.endsWith("/")) {
            String lastSegment = splitBase[pos - 1];
            result.append(lastSegment);
            while (pos < splitPath.length) {
                if (result.length() != 0) {
                    result.append('/');
                }
                result.append(splitPath[pos]);
                ++pos;
            }
        } else if (pos == splitBase.length) {
            while (pos < splitPath.length) {
                if (result.length() != 0) {
                    result.append('/');
                }
                result.append(splitPath[pos]);
                ++pos;
            }
        } else {
            for (int posBase = pos; posBase < splitBase.length - 1; ++posBase) {
                if (result.length() != 0) {
                    result.append('/');
                }
                result.append("..");
            }
            if (normalizeBasePath.endsWith("/")) {
                if (result.length() != 0) {
                    result.append('/');
                }
                result.append("..");
            }
            while (pos < splitPath.length) {
                if (result.length() != 0) {
                    result.append('/');
                }
                result.append(splitPath[pos]);
                ++pos;
            }
        }
        if (result.length() == 0) {
            result.append('.');
        }
        return result.toString();
    }

    public static String removeStartSlash(String s) {
        if (s.startsWith("/")) {
            return s.substring(1);
        }
        return s;
    }

    public static String appendPathToBaseUri(String baseUri, String path) {
        boolean startSlash;
        if (baseUri == null) {
            throw new NullPointerException("baseUri");
        }
        if (path == null || path.length() == 0) {
            return baseUri;
        }
        boolean endSlash = baseUri.endsWith("/");
        boolean bl = startSlash = path.charAt(0) == '/';
        if (startSlash && endSlash) {
            return baseUri + path.substring(1);
        }
        if (startSlash || endSlash) {
            return baseUri + path;
        }
        return baseUri + '/' + path;
    }

    public static String appendAltToPath(String uri, MediaType mediaType) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (mediaType == null) {
            throw new NullPointerException("mediaType");
        }
        StringBuilder result = new StringBuilder(uri);
        if (uri.length() == 0) {
            result.append('.');
        }
        char appendCharacter = '?';
        if (uri.indexOf(63) != -1) {
            appendCharacter = '&';
        }
        result.append(appendCharacter);
        result.append("alt");
        result.append('=');
        result.append(MediaTypeUtils.toEncodedString(mediaType));
        return result.toString();
    }

    public static String contructUri(String scheme, String userInfo, String host, int port, String path, String query, String fragment) {
        StringBuilder buffer = new StringBuilder();
        if (scheme != null) {
            buffer.append(scheme);
            buffer.append("://");
        }
        if (userInfo != null) {
            buffer.append(userInfo);
            buffer.append("@");
        }
        if (host != null) {
            buffer.append(host);
        }
        if (port != -1) {
            buffer.append(":");
            buffer.append(port);
        }
        if (path != null) {
            buffer.append(path);
        }
        if (query != null) {
            buffer.append("?");
            buffer.append(query);
        }
        if (fragment != null) {
            buffer.append("#");
            buffer.append(fragment);
        }
        return buffer.toString();
    }

    public static String getQueryParamsStr(Map<String, String[]> queryParams, boolean escapeKeyParam) {
        if (queryParams == null || queryParams.size() < 1) {
            return "";
        }
        StringBuilder queryParamsStr = new StringBuilder();
        Set<String> queryParamsKey = queryParams.keySet();
        String appendStr = "";
        for (String key : queryParamsKey) {
            String[] params = queryParams.get(key);
            if (params == null) continue;
            for (String paramInArray : params) {
                queryParamsStr.append(appendStr);
                queryParamsStr.append(escapeKeyParam ? UriEncoder.encodeString(key) : key).append("=").append(escapeKeyParam ? UriEncoder.encodeString(paramInArray) : paramInArray);
                appendStr = "&";
            }
        }
        return queryParamsStr.toString();
    }

    public static String appendQueryParamsToPath(String uri, Map<String, String[]> queryParams, boolean escapeKeyParam) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (queryParams == null || queryParams.size() < 1) {
            return uri;
        }
        StringBuilder result = new StringBuilder(uri);
        if (uri.length() == 0) {
            result.append('.');
        }
        char appendCharacter = '?';
        if (uri.indexOf(63) != -1) {
            appendCharacter = '&';
        }
        return uri + appendCharacter + UriHelper.getQueryParamsStr(queryParams, escapeKeyParam);
    }

    public static List<PathSegment> parsePath(String path) {
        String[] segmentsArray = StringUtils.fastSplitTemplate(path, "/", true);
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>(segmentsArray.length);
        for (String segment : segmentsArray) {
            pathSegments.add(new PathSegmentImpl(segment, null));
        }
        return pathSegments;
    }

    public static MultivaluedMap<String, String> parseQuery(String queryStr) {
        String[] paramsArray;
        MultivaluedMapImpl<String, String> query = new MultivaluedMapImpl<String, String>();
        if (queryStr == null || queryStr.length() == 0) {
            return query;
        }
        for (String param : paramsArray = StringUtils.fastSplit(queryStr, "&")) {
            int index = param.indexOf(61);
            String name = param;
            String value = null;
            if (index != -1) {
                name = param.substring(0, index);
                value = param.substring(index + 1);
            }
            query.add(name, value);
        }
        return query;
    }

    public static String normalize(String uri) {
        uri = UriPathNormalizer.normalize(uri);
        uri = UriEncoder.normalize(uri);
        return uri;
    }
}

