/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.clerezza.triaxrs.util.PathMatching;
import org.apache.clerezza.triaxrs.util.TemplateEncoder;
import org.apache.clerezza.utils.UriException;

public class URITemplate
implements Comparable<URITemplate> {
    int literalCharacters = 0;
    int capturingGroups = 0;
    List<TemplateSection> templateSections = new ArrayList<TemplateSection>();
    private String templateString;

    public URITemplate(String rawTemplateString) {
        try {
            this.templateString = TemplateEncoder.encode(rawTemplateString, "UTF-8");
        }
        catch (UriException ex) {
            throw new RuntimeException(ex);
        }
        StringReader stringReader = new StringReader(this.templateString);
        boolean readingVariableName = false;
        StringWriter sectionWriter = new StringWriter();
        try {
            boolean ommitNextCharIfSlash = true;
            int ch = stringReader.read();
            while (ch != -1) {
                block16: {
                    block18: {
                        block17: {
                            String sectionString;
                            block15: {
                                if (ch != 123) break block15;
                                if (readingVariableName) {
                                    throw new RuntimeException("{ in variable name");
                                }
                                sectionString = sectionWriter.toString();
                                if (sectionString.length() > 0) {
                                    if (!sectionString.equals("/")) {
                                        this.templateSections.add(new TemplateSection(sectionString, false));
                                    }
                                    sectionWriter = new StringWriter();
                                }
                                readingVariableName = true;
                                break block16;
                            }
                            if (ch != 125) break block17;
                            if (!readingVariableName) {
                                throw new RuntimeException("unbalanced }");
                            }
                            sectionString = sectionWriter.toString();
                            this.templateSections.add(new TemplateSection(sectionString, true));
                            ++this.capturingGroups;
                            sectionWriter = new StringWriter();
                            readingVariableName = false;
                            ommitNextCharIfSlash = true;
                            break block16;
                        }
                        if (!ommitNextCharIfSlash) break block18;
                        ommitNextCharIfSlash = false;
                        if (ch == 47) break block16;
                    }
                    sectionWriter.write(ch);
                }
                ch = stringReader.read();
            }
            if (readingVariableName) {
                throw new RuntimeException("unterminated variable name");
            }
            String lastSection = sectionWriter.toString();
            if (lastSection.length() > 0) {
                this.templateSections.add(new TemplateSection(lastSection, false));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PathMatching match(String uriPath) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String remaingUriPath = uriPath.length() > 0 && uriPath.charAt(0) == '/' ? uriPath.substring(1) : uriPath;
        for (TemplateSection templateSection : this.templateSections) {
            int usedTillPos = this.handleSection(templateSection, remaingUriPath, parameters);
            if (usedTillPos == -1) {
                return null;
            }
            if (remaingUriPath.length() > usedTillPos && remaingUriPath.charAt(usedTillPos) == '/') {
                ++usedTillPos;
            }
            remaingUriPath = remaingUriPath.substring(usedTillPos);
        }
        return new PathMatching(parameters, remaingUriPath);
    }

    private int handleSection(TemplateSection templateSection, String subPath, Map<String, String> result) {
        int i;
        if (templateSection.variable) {
            if (templateSection.pattern == null) {
                char ch;
                int i2;
                StringWriter valueWriter = new StringWriter();
                for (i2 = 0; i2 < subPath.length() && (ch = subPath.charAt(i2)) != '/'; ++i2) {
                    valueWriter.write(ch);
                }
                result.put(templateSection.value, valueWriter.toString());
                return i2;
            }
            Matcher matcher = templateSection.pattern.matcher(subPath);
            if (!matcher.lookingAt()) {
                return -1;
            }
            int end = matcher.end();
            result.put(templateSection.value, subPath.substring(0, end));
            return end;
        }
        if (templateSection.value.length() > subPath.length()) {
            return -1;
        }
        byte[] templateBytes = templateSection.value.getBytes();
        int subPathOffSet = 0;
        for (i = 0; i < subPath.length() && i < templateBytes.length; ++i) {
            char uriChar = subPath.charAt(i + subPathOffSet);
            if (uriChar == templateBytes[i]) continue;
            if (i == 0 && templateBytes[0] == 47 && (uriChar = subPath.charAt(1)) == templateBytes[i]) {
                subPathOffSet = 1;
                continue;
            }
            return -1;
        }
        if (subPath.length() == i + subPathOffSet || subPath.charAt(i + subPathOffSet) == '/') {
            return i + subPathOffSet;
        }
        return -1;
    }

    @Override
    public int compareTo(URITemplate o) {
        if (this.literalCharacters > o.literalCharacters) {
            return -1;
        }
        if (this.literalCharacters < o.literalCharacters) {
            return 1;
        }
        if (this.capturingGroups > o.capturingGroups) {
            return -1;
        }
        if (this.capturingGroups < o.capturingGroups) {
            return 1;
        }
        return this.templateString.compareTo(o.templateString);
    }

    public String toString() {
        return this.templateString;
    }

    public boolean equals(Object obj) {
        return this.templateString.equals(((URITemplate)obj).templateString);
    }

    public int hashCode() {
        return this.templateString.hashCode();
    }

    private class TemplateSection {
        boolean variable;
        String value;
        Pattern pattern;

        public TemplateSection(String value, boolean variable) {
            while (value.endsWith("/")) {
                value = value.substring(0, value.length() - 1);
            }
            this.variable = variable;
            if (variable) {
                int colonPos = value.indexOf(58);
                if (colonPos != -1) {
                    String regexString = value.substring(colonPos + 1);
                    value = value.substring(0, colonPos);
                    this.pattern = Pattern.compile(regexString);
                }
            } else {
                URITemplate.this.literalCharacters += value.length();
            }
            this.value = value;
        }

        public String toString() {
            if (this.variable) {
                return "{" + this.value + ":" + this.pattern + "}";
            }
            return this.value;
        }
    }
}

