/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.apache.clerezza.triaxrs.util.AcceptCharset;
import org.apache.clerezza.triaxrs.util.MultivaluedMapImpl;
import org.apache.clerezza.triaxrs.util.SoftConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProviderUtils.class);
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static SoftConcurrentMap<String, Boolean> validCharsets = new SoftConcurrentMap();
    private static SoftConcurrentMap<String, String> preferredCharsets = new SoftConcurrentMap();

    public static String getCharsetOrNull(MediaType m) {
        String name = m == null ? null : m.getParameters().get("charset");
        return name == null ? null : name;
    }

    public static String getCharset(MediaType m) {
        return ProviderUtils.getCharset(m, null);
    }

    public static String getCharset(MediaType m, HttpHeaders requestHeaders) {
        String name;
        logger.debug("getCharset({}, {})", (Object)m, (Object)requestHeaders);
        String string = name = m == null ? null : m.getParameters().get("charset");
        if (name != null) {
            logger.debug("getCharset() returning {} since parameter was set", (Object)name);
            return name;
        }
        if (requestHeaders == null) {
            logger.debug("getCharset() returning {} since requestHeaders was null", (Object)DEFAULT_CHARSET);
            return DEFAULT_CHARSET;
        }
        List<String> acceptableCharsets = requestHeaders.getRequestHeader("Accept-Charset");
        if (acceptableCharsets == null || acceptableCharsets.isEmpty()) {
            logger.debug("getCharset() returning {} since no Accept-Charset header", (Object)DEFAULT_CHARSET);
            return DEFAULT_CHARSET;
        }
        StringBuilder acceptCharsetsTemp = new StringBuilder();
        acceptCharsetsTemp.append(acceptableCharsets.get(0));
        for (int c = 1; c < acceptableCharsets.size(); ++c) {
            acceptCharsetsTemp.append(",");
            acceptCharsetsTemp.append(acceptableCharsets.get(c));
        }
        String acceptCharsets = acceptCharsetsTemp.toString();
        logger.debug("acceptCharsets combined value is {}", (Object)acceptCharsets);
        String cached = preferredCharsets.get(acceptCharsets);
        if (cached != null) {
            return cached;
        }
        AcceptCharset charsets = AcceptCharset.valueOf(acceptCharsets);
        if (charsets.isAnyCharsetAllowed()) {
            preferredCharsets.put(acceptCharsets, DEFAULT_CHARSET);
            return DEFAULT_CHARSET;
        }
        List<String> orderedCharsets = charsets.getAcceptableCharsets();
        logger.debug("orderedCharsets is {}", orderedCharsets);
        if (!orderedCharsets.isEmpty()) {
            for (int c = 0; c < orderedCharsets.size(); ++c) {
                String charset = orderedCharsets.get(c);
                try {
                    Boolean b = validCharsets.get(charset);
                    if (b != null && b.booleanValue()) {
                        logger.debug("getCharset() returning {} since highest Accept-Charset value", (Object)charset);
                        preferredCharsets.put(acceptCharsets, charset);
                        return charset;
                    }
                    Charset.forName(charset);
                    validCharsets.put(charset, Boolean.TRUE);
                    logger.debug("getCharset() returning {} since highest Accept-Charset value", (Object)charset);
                    preferredCharsets.put(acceptCharsets, charset);
                    return charset;
                }
                catch (IllegalCharsetNameException e) {
                    logger.debug("IllegalCharsetNameException for {}", (Object)charset, (Object)e);
                    validCharsets.put(charset, Boolean.FALSE);
                    continue;
                }
                catch (UnsupportedCharsetException e) {
                    logger.debug("UnsupportedCharsetException for {}", (Object)charset, (Object)e);
                    validCharsets.put(charset, Boolean.FALSE);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    logger.debug("IllegalArgumentException for {}", (Object)charset, (Object)e);
                    validCharsets.put(charset, Boolean.FALSE);
                }
            }
        }
        logger.debug("getCharset() returning {} since no explicit charset required", (Object)DEFAULT_CHARSET);
        preferredCharsets.put(acceptCharsets, DEFAULT_CHARSET);
        return DEFAULT_CHARSET;
    }

    public static Reader createReader(InputStream stream, MediaType mediaType) {
        Charset charset = Charset.forName(ProviderUtils.getCharset(mediaType));
        return new InputStreamReader(stream, charset);
    }

    public static Writer createWriter(OutputStream stream, MediaType mediaType) {
        Charset charset = Charset.forName(ProviderUtils.getCharset(mediaType));
        return new OutputStreamWriter(stream, charset);
    }

    private static ByteArrayOutputStream readFromStream(InputStream stream) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        ProviderUtils.copyStream(stream, os);
        return os;
    }

    public static byte[] readFromStreamAsBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream os = ProviderUtils.readFromStream(stream);
        return os.toByteArray();
    }

    public static String readFromStreamAsString(InputStream stream, MediaType mt) throws IOException {
        ByteArrayOutputStream os = ProviderUtils.readFromStream(stream);
        return os.toString(ProviderUtils.getCharset(mt));
    }

    public static void writeToStream(String string, OutputStream os, MediaType mt) throws IOException {
        os.write(string.getBytes(ProviderUtils.getCharset(mt)));
    }

    public static void copyStream(InputStream src, OutputStream dst) throws IOException {
        byte[] bytes = new byte[1024];
        int read = 0;
        while ((read = src.read(bytes)) != -1) {
            dst.write(bytes, 0, read);
        }
    }

    public static String writeToString(Providers providers, Object object, MediaType mediaType) throws IOException {
        return ProviderUtils.writeToString(providers, object, object.getClass(), mediaType);
    }

    public static String writeToString(Providers providers, Object object, Class<?> type, MediaType mediaType) throws IOException {
        return ProviderUtils.writeToString(providers, object, type, type, mediaType);
    }

    public static String writeToString(Providers providers, Object object, Class<?> type, Type genericType, MediaType mediaType) throws IOException {
        return ProviderUtils.writeToString(providers, object, type, type, new MultivaluedMapImpl<String, Object>(), mediaType);
    }

    public static String writeToString(Providers providers, Object object, Class<?> type, Type genericType, MultivaluedMap<String, Object> httpHeaders, MediaType mediaType) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        MessageBodyWriter<?> writer = providers.getMessageBodyWriter(type, genericType, null, mediaType);
        if (writer == null) {
            return null;
        }
        writer.writeTo(object, type, genericType, new Annotation[0], mediaType, httpHeaders, os);
        String contentString = os.toString(ProviderUtils.getCharset(mediaType));
        return contentString;
    }

    public static <T> T readFromString(Providers providers, String input, Class<T> type, MediaType mediaType) throws IOException {
        return ProviderUtils.readFromString(providers, input, type, type, mediaType);
    }

    public static <T> T readFromString(Providers providers, String input, Class<T> type, Type genericType, MediaType mediaType) throws IOException {
        return ProviderUtils.readFromString(providers, input, type, genericType, new MultivaluedMapImpl<String, String>(), mediaType);
    }

    public static <T> T readFromString(Providers providers, String input, Class<T> type, Type genericType, MultivaluedMap<String, String> httpHeaders, MediaType mediaType) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes(ProviderUtils.getCharset(mediaType)));
        MessageBodyReader<T> reader = providers.getMessageBodyReader(type, genericType, null, mediaType);
        if (reader == null) {
            return null;
        }
        return reader.readFrom(type, genericType, new Annotation[0], mediaType, httpHeaders, is);
    }
}

