/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.util;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.apache.clerezza.triaxrs.util.QueryStringParser;
import org.apache.clerezza.triaxrs.util.uri.UriEncoder;

public final class PathSegmentImpl
implements PathSegment {
    private String path;
    private MultivaluedMap<String, String> matrixParameters;

    PathSegmentImpl(String path, MultivaluedMap<String, String> matrixParameters) {
        this.path = path;
        this.matrixParameters = matrixParameters;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public MultivaluedMap<String, String> getMatrixParameters() {
        return this.matrixParameters;
    }

    public String toString() {
        return "[Path: " + this.path + "," + this.matrixParameters + "]";
    }

    public static PathSegment parse(String string, boolean disableDecoding) {
        String path;
        MultivaluedMap<String, String> matrixMap = null;
        int colonPos = string.indexOf(59);
        if (colonPos != -1) {
            String matrixParameters = string.substring(colonPos + 1);
            path = colonPos == 0 ? "" : string.substring(0, colonPos);
            matrixMap = QueryStringParser.extractPathParameters(matrixParameters, ";", !disableDecoding);
        } else {
            path = string;
        }
        if (!disableDecoding) {
            path = UriEncoder.decodeString(path);
        }
        return new PathSegmentImpl(path, matrixMap);
    }
}

