/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.clerezza.triaxrs.util.AcceptHeader;

public class MediaTypeComparator
implements Comparator<MediaType> {
    private static final Map<MediaType, Float> fallBackQ = new HashMap<MediaType, Float>();
    private AcceptHeader acceptHeader;

    private static int fallBackCompare(MediaType o1, MediaType o2) {
        float q2;
        float q1 = MediaTypeComparator.getFallBackQ(o1);
        if (q1 == (q2 = MediaTypeComparator.getFallBackQ(o2))) {
            return 0;
        }
        if (q1 > q2) {
            return -1;
        }
        return 1;
    }

    public MediaTypeComparator() {
    }

    public MediaTypeComparator(AcceptHeader acceptHeader) {
        this.acceptHeader = acceptHeader;
    }

    public static int inconsistentCompare(MediaType o1, MediaType o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        int wilchCharComparison = MediaTypeComparator.compareByWildCardCount(o1, o2);
        if (wilchCharComparison == 0) {
            float q2;
            float q1 = MediaTypeComparator.getQ(o1);
            if (q1 == (q2 = MediaTypeComparator.getQ(o2))) {
                return MediaTypeComparator.fallBackCompare(o1, o2);
            }
            if (q1 > q2) {
                return -1;
            }
            return 1;
        }
        return wilchCharComparison;
    }

    @Override
    public int compare(MediaType o1, MediaType o2) {
        int inconsistentCompare;
        if (o1.equals(o2)) {
            return 0;
        }
        if (this.acceptHeader != null) {
            if (this.acceptHeader.getAcceptedQuality(o1) > this.acceptHeader.getAcceptedQuality(o2)) {
                return -1;
            }
            if (this.acceptHeader.getAcceptedQuality(o1) < this.acceptHeader.getAcceptedQuality(o2)) {
                return 1;
            }
        }
        if ((inconsistentCompare = MediaTypeComparator.inconsistentCompare(o1, o2)) == 0) {
            return o1.toString().compareTo(o2.toString());
        }
        return inconsistentCompare;
    }

    public static int compareByWildCardCount(MediaType o1, MediaType o2) {
        int w2;
        int w1 = MediaTypeComparator.countWildChars(o1);
        if (w1 == (w2 = MediaTypeComparator.countWildChars(o2))) {
            return 0;
        }
        if (w1 < w2) {
            return -1;
        }
        return 1;
    }

    public static int countWildChars(MediaType m) {
        if (m.getType().equals("*")) {
            return 2;
        }
        if (m.getSubtype().equals("*")) {
            return 1;
        }
        return 0;
    }

    private static float getQ(MediaType m) {
        String qString = m.getParameters().get("q");
        if (qString == null) {
            return 1.0f;
        }
        return Float.parseFloat(qString);
    }

    private static float getFallBackQ(MediaType m) {
        if (fallBackQ.containsKey(m)) {
            return fallBackQ.get(m).floatValue();
        }
        return 0.0f;
    }

    static {
        fallBackQ.put(MediaType.APPLICATION_XHTML_XML_TYPE, new Float(1.0f));
        fallBackQ.put(MediaType.valueOf("text/html"), new Float(0.9f));
        fallBackQ.put(MediaType.valueOf("application/rdf+xml"), new Float(0.8f));
    }
}

