/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.util;

import java.util.Comparator;
import javax.ws.rs.core.MediaType;
import org.apache.clerezza.triaxrs.util.AcceptHeader;
import org.apache.clerezza.triaxrs.util.MediaTypeComparator;

public class InconsistentMediaTypeComparator
implements Comparator<MediaType> {
    private AcceptHeader acceptHeader;

    public InconsistentMediaTypeComparator() {
    }

    public InconsistentMediaTypeComparator(AcceptHeader acceptHeader) {
        this.acceptHeader = acceptHeader;
    }

    @Override
    public int compare(MediaType o1, MediaType o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        if (this.acceptHeader != null) {
            if (this.acceptHeader.getAcceptedQuality(o1) > this.acceptHeader.getAcceptedQuality(o2)) {
                return -1;
            }
            if (this.acceptHeader.getAcceptedQuality(o1) < this.acceptHeader.getAcceptedQuality(o2)) {
                return 1;
            }
        }
        return MediaTypeComparator.inconsistentCompare(o1, o2);
    }
}

