/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.core.MediaType;
import org.apache.clerezza.triaxrs.util.MediaTypeComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptHeader {
    private static final Logger logger = LoggerFactory.getLogger(AcceptHeader.class);
    private SortedSet<AcceptHeaderEntry> entries = new TreeSet<AcceptHeaderEntry>();

    public String toString() {
        return this.entries.toString();
    }

    public AcceptHeader(List<String> entryStrings) {
        if (entryStrings == null || entryStrings.size() == 0) {
            this.entries.add(new AcceptHeaderEntry(MediaType.WILDCARD_TYPE));
        } else {
            for (String string : entryStrings) {
                try {
                    this.entries.add(new AcceptHeaderEntry(MediaType.valueOf(string)));
                }
                catch (IllegalArgumentException ex) {
                    logger.warn("The string \"" + string + "\" is not a valid mediatype", (Throwable)ex);
                }
            }
        }
    }

    public List<MediaType> getEntries() {
        ArrayList<MediaType> result = new ArrayList<MediaType>();
        for (AcceptHeaderEntry entry : this.entries) {
            result.add(entry.mediaType);
        }
        return result;
    }

    public int getAcceptedQuality(MediaType type) {
        for (AcceptHeaderEntry acceptHeaderEntry : this.entries) {
            if (!this.isSameOrSubtype(type, acceptHeaderEntry.mediaType)) continue;
            return acceptHeaderEntry.quality;
        }
        Object[] reverseEntries = this.entries.toArray();
        for (int i = this.entries.size() - 1; i >= 0; --i) {
            AcceptHeaderEntry entry = (AcceptHeaderEntry)reverseEntries[i];
            if (!this.isSameOrSubtype(entry.mediaType, type)) continue;
            return entry.quality;
        }
        return 0;
    }

    public Set<MediaType> getAcceptingMediaType(MediaType type) {
        HashSet<MediaType> result = new HashSet<MediaType>();
        double currentQValue = 0.0;
        for (AcceptHeaderEntry acceptHeaderEntry : this.entries) {
            if (!acceptHeaderEntry.mediaType.isCompatible(type)) continue;
            if (!((double)acceptHeaderEntry.quality >= currentQValue)) break;
            currentQValue = acceptHeaderEntry.quality;
            result.add(acceptHeaderEntry.mediaType);
        }
        return result;
    }

    private boolean isSameOrSubtype(MediaType t1, MediaType t2) {
        String type1 = t1.getType();
        String subtype1 = t1.getSubtype();
        String type2 = t2.getType();
        String subtype2 = t2.getSubtype();
        if (type2.equals("*") && subtype2.equals("*")) {
            return true;
        }
        if (type1.equalsIgnoreCase(type2) && subtype2.equals("*")) {
            return true;
        }
        return type1.equalsIgnoreCase(type2) && subtype1.equalsIgnoreCase(subtype2);
    }

    static class AcceptHeaderEntry
    implements Comparable<AcceptHeaderEntry> {
        private MediaTypeComparator mediaTypeComparator = new MediaTypeComparator();
        MediaType mediaType;
        int quality;

        AcceptHeaderEntry(MediaType mediaType) {
            HashMap<String, String> parametersWithoutQ = new HashMap<String, String>();
            parametersWithoutQ.putAll(mediaType.getParameters());
            String qValue = (String)parametersWithoutQ.remove("q");
            this.mediaType = new MediaType(mediaType.getType(), mediaType.getSubtype(), parametersWithoutQ);
            this.quality = qValue == null ? 1000 : (int)(Float.parseFloat(qValue) * 1000.0f);
        }

        @Override
        public int compareTo(AcceptHeaderEntry o) {
            if (this.equals(o)) {
                return 0;
            }
            if (this.quality == o.quality) {
                return this.mediaTypeComparator.compare(this.mediaType, o.mediaType);
            }
            return o.quality - this.quality;
        }

        public String toString() {
            return this.mediaType + " with q=" + this.quality + ";";
        }
    }
}

