/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.providers.provided;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.clerezza.triaxrs.util.MediaTypeUtils;
import org.apache.clerezza.triaxrs.util.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SourceProvider
implements MessageBodyWriter<Source> {
    private static TransformerFactory transformerFactory;
    private static DocumentBuilderFactory documentBuilderFactory;
    private static final Logger logger;

    protected boolean isReadable(MediaType mediaType) {
        return MediaTypeUtils.isXmlType(mediaType);
    }

    @Override
    public long getSize(Source t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Source.class.isAssignableFrom(type) && MediaTypeUtils.isXmlType(mediaType);
    }

    @Override
    public void writeTo(Source t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        StreamResult sr = new StreamResult(entityStream);
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(t, sr);
        }
        catch (TransformerException e) {
            throw SourceProvider.asIOException(e);
        }
    }

    private static IOException asIOException(Exception e) throws IOException {
        IOException exception = new IOException();
        exception.initCause(e);
        return exception;
    }

    static {
        logger = LoggerFactory.getLogger(SourceProvider.class);
        transformerFactory = TransformerFactory.newInstance();
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
    }

    @Provider
    @Consumes(value={"text/xml", "application/xml", "*/*"})
    @Produces(value={"text/xml", "application/xml", "*/*"})
    public static class DOMSourceProvider
    extends SourceProvider
    implements MessageBodyReader<DOMSource> {
        @Override
        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return DOMSource.class == type && super.isReadable(mediaType);
        }

        private void setupDocumentBuilderToFilterDTD(DocumentBuilder dbuilder) {
            dbuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String name, String baseURI) throws SAXException, IOException {
                    throw new SAXParseException(Messages.getMessage("entityRefsNotSupported"), null, null);
                }
            });
            try {
                documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException e) {
                logger.error(e.getMessage());
            }
            try {
                documentBuilderFactory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }

        @Override
        public DOMSource readFrom(Class<DOMSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            try {
                DocumentBuilder dbuilder = documentBuilderFactory.newDocumentBuilder();
                return new DOMSource(dbuilder.parse(entityStream));
            }
            catch (SAXException e) {
                logger.error(Messages.getMessage("saxParseException", type.getName()), (Throwable)e);
                throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
            }
            catch (ParserConfigurationException e) {
                logger.error(Messages.getMessage("saxParserConfigurationException"), (Throwable)e);
                throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
            }
        }
    }

    @Provider
    @Consumes(value={"text/xml", "application/xml", "*/*"})
    @Produces(value={"text/xml", "application/xml", "*/*"})
    public static class SAXSourceProvider
    extends SourceProvider
    implements MessageBodyReader<SAXSource> {
        @Override
        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return SAXSource.class == type && super.isReadable(mediaType);
        }

        @Override
        public SAXSource readFrom(Class<SAXSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            return new SAXSource(new InputSource(entityStream));
        }
    }

    @Provider
    @Consumes(value={"text/xml", "application/xml", "*/*"})
    @Produces(value={"text/xml", "application/xml", "*/*"})
    public static class StreamSourceProvider
    extends SourceProvider
    implements MessageBodyReader<Source> {
        @Override
        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return type.isAssignableFrom(StreamSource.class) && super.isReadable(mediaType);
        }

        @Override
        public StreamSource readFrom(Class<Source> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            return new StreamSource(entityStream);
        }
    }
}

