/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.providers.provided;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.activation.DataHandler;
import javax.activation.UnsupportedDataTypeException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;

public class JafMessageBodyWriter<T>
implements MessageBodyWriter<T> {
    private MediaType mediaType;

    public JafMessageBodyWriter(T entity, MediaType mediaType) throws IOException, UnsupportedDataTypeException {
        DataHandler dataHandler = new DataHandler(entity, mediaType.toString());
        dataHandler.getInputStream();
        this.mediaType = mediaType;
    }

    @Override
    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        try {
            DataHandler dataHandler = new DataHandler(t, mediaType.toString());
            InputStream in = dataHandler.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int BUF_SIZE = 256;
            byte[] buffer = new byte[256];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) > -1) {
                out.write(buffer, 0, bytesRead);
            }
            in.close();
            return out.size();
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (!mediaType.equals(this.mediaType)) {
            throw new IOException("Wrong usage of JAFProvider. MediaType changed!");
        }
        DataHandler dataHandler = new DataHandler(t, mediaType.toString());
        dataHandler.getInputStream();
        JafMessageBodyWriter.writeTo(dataHandler.getInputStream(), entityStream);
    }

    private static final void writeTo(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] data = new byte[2048];
        while ((read = in.read(data)) != -1) {
            out.write(data, 0, read);
        }
    }
}

