/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.providers.provided;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.clerezza.triaxrs.util.MultivaluedMapImpl;
import org.apache.clerezza.triaxrs.util.ProviderUtils;
import org.apache.clerezza.triaxrs.util.uri.UriEncoder;

@Provider
@Produces(value={"application/x-www-form-urlencoded"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class FormMultivaluedMapProvider
implements MessageBodyWriter<MultivaluedMap<String, ? extends Object>>,
MessageBodyReader<MultivaluedMap<String, String>> {
    @Override
    public long getSize(MultivaluedMap<String, ? extends Object> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultivaluedMap.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(MultivaluedMap<String, ? extends Object> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String string = MultivaluedMapImpl.toString(t, "&");
        string = UriEncoder.encodeQuery(string, true);
        ProviderUtils.writeToStream(string, entityStream, mediaType);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (MultivaluedMap.class != type || !(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType pType = (ParameterizedType)genericType;
        Type[] actualTypeArguments = pType.getActualTypeArguments();
        Type type1 = actualTypeArguments[0];
        Type type2 = actualTypeArguments[1];
        return type1 instanceof Class && ((Class)type1).equals(String.class) && type2 instanceof Class && ((Class)type2).equals(String.class);
    }

    @Override
    public MultivaluedMap<String, String> readFrom(Class<MultivaluedMap<String, String>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MultivaluedMapImpl<String, String> map = new MultivaluedMapImpl<String, String>();
        String string = ProviderUtils.readFromStreamAsString(entityStream, mediaType);
        StringTokenizer tokenizer = new StringTokenizer(string, "&");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.indexOf(61);
            if (idx < 0) {
                map.add(URLDecoder.decode(token, "UTF-8"), null);
                continue;
            }
            if (idx <= 0) continue;
            map.add(URLDecoder.decode(token.substring(0, idx), "UTF-8"), URLDecoder.decode(token.substring(idx + 1), "UTF-8"));
        }
        return map;
    }
}

