/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.providers.provided;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.clerezza.triaxrs.util.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class FileProvider
implements MessageBodyWriter<File>,
MessageBodyReader<File> {
    private static final Logger logger = LoggerFactory.getLogger(FileProvider.class);
    private String prefix = "FP_PRE";
    private String uploadDir = null;
    private String suffix = "FP_SUF";

    @Override
    public long getSize(File t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return t.length();
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(File t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (!t.canRead() || t.isDirectory()) {
            if (logger.isWarnEnabled()) {
                logger.warn(Messages.getMessage("cannotUseFileAsResponse", t.getAbsoluteFile()));
            }
            throw new WebApplicationException();
        }
        FileInputStream fis = new FileInputStream(t);
        try {
            this.pipe(fis, entityStream);
        }
        finally {
            fis.close();
        }
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(File.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File readFrom(Class<File> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        File dir = null;
        if (!(this.uploadDir == null || (dir = new File(this.uploadDir)).exists() && dir.isDirectory())) {
            dir = null;
            if (logger.isWarnEnabled()) {
                logger.warn(Messages.getMessage("uploadDirDoesNotExist", this.uploadDir));
            }
            throw new WebApplicationException();
        }
        File f = File.createTempFile(this.prefix, this.suffix, dir);
        FileOutputStream fos = new FileOutputStream(f);
        try {
            this.pipe(entityStream, fos);
        }
        finally {
            fos.close();
        }
        return f;
    }

    private void pipe(InputStream is, OutputStream os) throws IOException {
        byte[] ba = new byte[1024];
        int i = is.read(ba);
        while (i != -1) {
            os.write(ba, 0, i);
            i = is.read(ba);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getUploadDir() {
        return this.uploadDir;
    }

    public void setUploadDir(String uploadDir) {
        this.uploadDir = uploadDir;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

