/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.providers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.apache.clerezza.triaxrs.InjectionUtilities;
import org.apache.clerezza.triaxrs.JaxRsHandler;
import org.apache.clerezza.triaxrs.RootResources;
import org.apache.clerezza.triaxrs.WebRequest;
import org.apache.clerezza.triaxrs.WebRequestProxy;
import org.apache.clerezza.triaxrs.parameterinjectors.UnsupportedFieldType;
import org.apache.clerezza.triaxrs.providers.CascadeNode;
import org.apache.clerezza.triaxrs.providers.ProvidersImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.wrhapi.HandlerException;

public class CascadingProviders
implements Providers {
    private Logger logger = LoggerFactory.getLogger(CascadingProviders.class);
    CascadeNode root = new CascadeNode();

    public void addClass(Class<?> componentClass, String pathPrefix) {
        try {
            this.addInstance(componentClass.newInstance(), pathPrefix);
        }
        catch (InstantiationException ex) {
            this.logger.error("Exception {}", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            this.logger.error("Exception {}", (Throwable)ex);
        }
    }

    public void addInstance(Object component, String pathPrefix) {
        this.injectContext(component);
        String[] pathSections = this.getPathSections(pathPrefix);
        CascadeNode current = this.root;
        for (String section : pathSections) {
            if (section.equals("")) continue;
            current = current.createChild(section);
        }
        current.getProviders().addInstance(component);
    }

    private void injectContext(Object provider) {
        WebRequest requestProxy = WebRequestProxy.createProxy();
        try {
            InjectionUtilities.injectFields(requestProxy, null, JaxRsHandler.providers, provider);
        }
        catch (HandlerException ex) {
            this.logger.debug("Exception {}", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (UnsupportedFieldType ex) {
            this.logger.debug("Exception {}", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private String[] getPathSections(String pathPrefix) {
        if (pathPrefix.startsWith("/")) {
            return pathPrefix.substring(1).split("/");
        }
        return pathPrefix.split("/");
    }

    public void removeInstance(Object component, String pathPrefix) {
        CascadeNode current;
        String[] pathSections = this.getPathSections(pathPrefix);
        CascadeNode prev = current = this.root;
        int pos = 0;
        for (String section : pathSections) {
            if (current == null) break;
            ++pos;
            prev = current;
            if (section.equals("")) continue;
            current = current.getChild(section);
        }
        if (current != null) {
            ProvidersImpl providers = current.getProviders();
            providers.removeInstance(component);
            if (providers.isEmpty() && !current.hasChild() && pos > 0) {
                prev.deleteChild(pathSections[pos - 1]);
            }
        }
    }

    @Override
    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        return this.getMessageBodyReader(c, t, as, mediaType, this.getRequestUriWithoutStartingSlash());
    }

    private String getRequestUriWithoutStartingSlash() {
        String requestUri = RootResources.getCurrentRequestUri();
        if (requestUri.startsWith("/")) {
            return requestUri.substring(1);
        }
        return requestUri;
    }

    <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType, String currentRequestUri) {
        String[] pathSections = currentRequestUri.split("/");
        return this.getMessageBodyReader(c, t, as, mediaType, this.root, pathSections, 0);
    }

    private <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType, CascadeNode node, String[] pathSections, int pos) {
        CascadeNode child;
        MessageBodyReader<T> result = null;
        if (pos < pathSections.length && (child = node.getChild(pathSections[pos])) != null) {
            result = this.getMessageBodyReader(c, t, as, mediaType, child, pathSections, pos + 1);
        }
        if (result == null) {
            return node.getProviders().getMessageBodyReader(c, t, as, mediaType);
        }
        return result;
    }

    @Override
    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        String currentRequestUri = this.getRequestUriWithoutStartingSlash();
        String[] pathSections = currentRequestUri.split("/");
        return this.getMessageBodyWriter(c, t, as, mediaType, this.root, pathSections, 0);
    }

    private <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType, CascadeNode node, String[] pathSections, int pos) {
        CascadeNode child;
        MessageBodyWriter<T> result = null;
        if (pos < pathSections.length && (child = node.getChild(pathSections[pos])) != null) {
            result = this.getMessageBodyWriter(c, t, as, mediaType, child, pathSections, pos + 1);
        }
        if (result == null) {
            return node.getProviders().getMessageBodyWriter(c, t, as, mediaType);
        }
        return result;
    }

    @Override
    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> c) {
        String currentRequestUri = this.getRequestUriWithoutStartingSlash();
        String[] pathSections = currentRequestUri.split("/");
        return this.getExceptionMapper(c, this.root, pathSections, 0);
    }

    private <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> c, CascadeNode node, String[] pathSections, int pos) {
        CascadeNode child;
        ExceptionMapper<T> result = null;
        if (pos < pathSections.length && (child = node.getChild(pathSections[pos])) != null) {
            result = this.getExceptionMapper(c, child, pathSections, pos + 1);
        }
        if (result == null) {
            return node.getProviders().getExceptionMapper(c);
        }
        return result;
    }
}

