/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.providers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

public class AggregatedProviders
implements Providers {
    private volatile Providers[] delegates;
    private final ReentrantReadWriteLock configLock;

    public AggregatedProviders(ReentrantReadWriteLock configLock, Providers ... delegates) {
        this.delegates = delegates;
        this.configLock = configLock;
    }

    public void reset(Providers ... delegates) {
        this.configLock.writeLock().lock();
        this.delegates = delegates;
        this.configLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Providers[] getDelegates() {
        this.configLock.readLock().lock();
        try {
            Providers[] providersArray = this.delegates;
            return providersArray;
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        this.configLock.readLock().lock();
        try {
            for (Providers providers : this.delegates) {
                MessageBodyReader<T> result = providers.getMessageBodyReader(type, genericType, annotations, mediaType);
                if (result == null) continue;
                MessageBodyReader<T> messageBodyReader = result;
                return messageBodyReader;
            }
        }
        finally {
            this.configLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        this.configLock.readLock().lock();
        try {
            for (Providers providers : this.delegates) {
                MessageBodyWriter<T> result = providers.getMessageBodyWriter(type, genericType, annotations, mediaType);
                if (result == null) continue;
                MessageBodyWriter<T> messageBodyWriter = result;
                return messageBodyWriter;
            }
        }
        finally {
            this.configLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        this.configLock.readLock().lock();
        try {
            for (Providers providers : this.delegates) {
                ExceptionMapper<T> result = providers.getExceptionMapper(type);
                if (result == null) continue;
                ExceptionMapper<T> exceptionMapper = result;
                return exceptionMapper;
            }
        }
        finally {
            this.configLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        this.configLock.readLock().lock();
        try {
            for (Providers providers : this.delegates) {
                ContextResolver<T> result = providers.getContextResolver(contextType, mediaType);
                if (result == null) continue;
                ContextResolver<T> contextResolver = result;
                return contextResolver;
            }
        }
        finally {
            this.configLock.readLock().unlock();
        }
        return null;
    }
}

