/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.prefixmanager;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.clerezza.jaxrs.extensions.prefixmanager.BundlePrefixManager;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriaxrsPrefixManager
implements BundlePrefixManager {
    public static final String TRIAXRS_MAPPINGS = "mappings";
    public static final String TRIAXRS_USE_DEFAULT_PREFIXES = "UseDefaultPrefix";
    public static final String TRIAXRS_USE_CUSTOM_PREFIXES = "UseCustomPrefix";
    private Logger logger = LoggerFactory.getLogger(TriaxrsPrefixManager.class);
    private ConfigurationAdmin configAdmin;
    private ComponentContext componentContext;

    public String getPrefix(Bundle bundle) {
        String prefix = "";
        String defaultPrefix = this.getDefaultPrefix(bundle);
        this.addDefaultMapping(bundle.getSymbolicName(), defaultPrefix);
        String customPrefix = this.getCustomPrefix(bundle);
        if (this.useDefaultPrefixes()) {
            prefix = defaultPrefix;
        }
        if (this.useCustomPrefixes()) {
            prefix = customPrefix != null ? customPrefix : defaultPrefix;
        }
        if ((prefix = prefix.trim()).endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    private Dictionary getProperties() {
        return this.componentContext.getProperties();
    }

    private Dictionary getMappings() {
        return TriaxrsPrefixManager.parseMappings((String[])this.getProperties().get(TRIAXRS_MAPPINGS));
    }

    private void addDefaultMapping(String symbolicName, String prefix) {
        if (this.configAdmin != null) {
            try {
                Dictionary<String, String> mappings;
                Configuration configuration = this.configAdmin.getConfiguration(TriaxrsPrefixManager.class.getName());
                Hashtable<String, String[]> properties = configuration.getProperties();
                if (properties == null) {
                    properties = new Hashtable<String, String[]>();
                }
                if ((mappings = TriaxrsPrefixManager.parseMappings((String[])((Dictionary)properties).get(TRIAXRS_MAPPINGS))).get(symbolicName) != null) {
                    return;
                }
                mappings.put(symbolicName, prefix);
                String[] newMappings = TriaxrsPrefixManager.unparseMappings(mappings);
                ((Dictionary)properties).put(TRIAXRS_MAPPINGS, newMappings);
                configuration.update(properties);
            }
            catch (IOException e) {
                this.logger.warn("Unable to update configuration: {}", (Object)e.toString());
            }
        } else {
            this.logger.warn("Cannot add prefix mapping. Configuration Admin is missing");
        }
    }

    private String getDefaultPrefix(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String defaultPrefix = (String)headers.get("Triaxrs-PathPrefix");
        if (defaultPrefix == null) {
            defaultPrefix = "";
        }
        return defaultPrefix;
    }

    private String getCustomPrefix(Bundle bundle) {
        return (String)this.getMappings().get(bundle.getSymbolicName());
    }

    private boolean useCustomPrefixes() {
        Boolean boolUseCustom = (Boolean)this.getProperties().get(TRIAXRS_USE_CUSTOM_PREFIXES);
        return boolUseCustom == null || boolUseCustom != false;
    }

    private boolean useDefaultPrefixes() {
        Boolean boolUseDefault = (Boolean)this.getProperties().get(TRIAXRS_USE_DEFAULT_PREFIXES);
        return boolUseDefault == null || boolUseDefault != false;
    }

    public static Dictionary<String, String> parseMappings(String[] mappings) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (mappings == null) {
            return result;
        }
        for (String mapping : mappings) {
            String[] parts = mapping.split("=");
            if (parts.length == 2) {
                ((Dictionary)result).put(parts[0], parts[1]);
                continue;
            }
            if (parts.length != 1) continue;
            ((Dictionary)result).put(parts[0], "");
        }
        return result;
    }

    public static String[] unparseMappings(Dictionary mappings) {
        Enumeration keys = mappings.keys();
        String[] result = new String[mappings.size()];
        int index = 0;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            result[index] = key + "=" + TriaxrsPrefixManager.formatPrefix((String)mappings.get(key));
            ++index;
        }
        return result;
    }

    private static String formatPrefix(String prefix) {
        if (!(prefix = prefix.trim()).startsWith("/")) {
            prefix = "/" + prefix;
        }
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    protected void bindConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.logger.debug("Binding configuration admin");
        this.configAdmin = configAdmin;
    }

    protected void unbindConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.logger.debug("Unbinding configuration admin");
    }

    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }
}

