/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.parameterinjectors;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ext.Providers;
import org.apache.clerezza.triaxrs.WebRequest;
import org.apache.clerezza.triaxrs.parameterinjectors.ConversionUtil;
import org.apache.clerezza.triaxrs.parameterinjectors.ParameterInjector;
import org.apache.clerezza.triaxrs.parameterinjectors.UnsupportedFieldType;
import org.apache.clerezza.triaxrs.util.QueryStringParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.wrhapi.HandlerException;

public class QueryParameterInjector
implements ParameterInjector<QueryParam> {
    private Logger logger = LoggerFactory.getLogger(QueryParameterInjector.class);

    @Override
    public <T> T getValue(WebRequest request, Map<String, String> pathParam, Providers providers, Type parameterType, QueryParam annotation, boolean encodingDisabled, String defaultValue) throws UnsupportedFieldType {
        try {
            String query = request.getWrhapiRequest().getRequestURI().getQuery();
            List<String> values = null;
            if (query != null) {
                values = QueryStringParser.getParameterValues(query, !encodingDisabled, annotation.value());
            }
            if (values == null && defaultValue != null) {
                values = Collections.singletonList(defaultValue);
            }
            return ConversionUtil.convert(values, parameterType, new ConversionUtil.Convertor[0]);
        }
        catch (HandlerException ex) {
            this.logger.debug("Exception {}", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

