/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.parameterinjectors;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.CookieParam;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.ext.Providers;
import org.apache.clerezza.triaxrs.WebRequest;
import org.apache.clerezza.triaxrs.headerDelegate.CookieHeaderDelegate;
import org.apache.clerezza.triaxrs.parameterinjectors.ConversionUtil;
import org.apache.clerezza.triaxrs.parameterinjectors.ParameterInjector;
import org.apache.clerezza.triaxrs.parameterinjectors.UnsupportedFieldType;
import org.wymiwyg.wrhapi.HeaderName;

public class CookieParameterInjector
implements ParameterInjector<CookieParam> {
    static final CookieHeaderDelegate cookieProvider = new CookieHeaderDelegate();

    @Override
    public <T> T getValue(WebRequest request, Map<String, String> pathParam, Providers providers, Type parameterType, CookieParam annotation, boolean encodingDisabled, String defaultValue) throws UnsupportedFieldType {
        List cookieValues = (List)request.getHeaders().get(HeaderName.COOKIE.toString());
        List<String> cookieValue = null;
        if (cookieValues != null) {
            for (String cookie : cookieValues) {
                if (!cookie.substring(0, cookie.indexOf("=")).trim().equals(annotation.value())) continue;
                cookieValue = Collections.singletonList(cookie);
                break;
            }
        }
        if (cookieValue == null && defaultValue != null) {
            cookieValue = Collections.singletonList(defaultValue);
        }
        return ConversionUtil.convert(cookieValue, parameterType, new ConversionUtil.Convertor<Cookie>(){

            @Override
            public Cookie convert(String string) {
                return cookieProvider.fromString(string);
            }
        });
    }
}

