/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.headerDelegate;

import java.util.Locale;
import javax.ws.rs.ext.RuntimeDelegate;

public class LocaleProvider
implements RuntimeDelegate.HeaderDelegate<Locale> {
    @Override
    public Locale fromString(String header) throws IllegalArgumentException {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        String[] parts = header.split(";");
        parts = parts[0].split("-");
        String language = "";
        String country = "";
        String variant = "";
        if (parts.length > 0) {
            if (parts[0].length() == 2) {
                language = parts[0];
            } else {
                throw new IllegalArgumentException();
            }
        }
        if (parts.length > 1) {
            if (parts[1].length() == 2) {
                country = parts[1];
            } else if (parts[1].length() >= 3 && parts[1].length() <= 8) {
                variant = parts[1];
            } else {
                throw new IllegalArgumentException();
            }
        }
        if (parts.length > 2) {
            variant = parts[2];
        }
        return new Locale(language, country, variant);
    }

    @Override
    public String toString(Locale locale) {
        String result = "";
        if (!locale.getLanguage().equals("")) {
            result = result + locale.getLanguage();
        }
        if (!locale.getCountry().equals("")) {
            result = result + "-" + locale.getCountry();
        }
        if (!locale.getVariant().equals("")) {
            result = result + "-" + locale.getVariant();
        }
        return result;
    }
}

