/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs.delegate;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.clerezza.triaxrs.JaxRsHandler;
import org.apache.clerezza.triaxrs.delegate.ResponseImpl;
import org.apache.clerezza.triaxrs.util.MultivaluedMapImpl;
import org.apache.clerezza.triaxrs.util.UriInfoImpl;

class ResponseBuilderImpl
extends Response.ResponseBuilder {
    private int status = -1;
    private MultivaluedMap<String, Object> headers = new MultivaluedMapImpl<String, Object>();
    private Object entity;

    @Override
    public Response build() {
        return new ResponseImpl(this.status, this.entity, this.headers);
    }

    @Override
    public Response.ResponseBuilder clone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Response.ResponseBuilder status(int status) {
        this.status = status;
        return this;
    }

    @Override
    public Response.ResponseBuilder entity(Object entity) {
        this.entity = entity;
        return this;
    }

    @Override
    public Response.ResponseBuilder type(MediaType type) {
        if (type == null) {
            this.headers.remove("Content-Type");
        }
        this.headers.putSingle("Content-Type", type);
        return this;
    }

    @Override
    public Response.ResponseBuilder type(String type) {
        if (type == null) {
            this.headers.remove("Content-Type");
        }
        this.headers.putSingle("Content-Type", type);
        return this;
    }

    @Override
    public Response.ResponseBuilder variant(Variant variant) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Response.ResponseBuilder variants(List<Variant> variants) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Response.ResponseBuilder language(String language) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Response.ResponseBuilder language(Locale language) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Response.ResponseBuilder location(URI location) {
        if (location == null) {
            this.headers.remove("Location");
        }
        try {
            UriInfoImpl uriInfo = new UriInfoImpl(JaxRsHandler.localRequest.get());
            URL baseUrl = uriInfo.getBaseUri().toURL();
            URL absolutizedUrl = new URL(baseUrl, location.toString());
            this.headers.putSingle("Location", absolutizedUrl.toString());
            return this;
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Response.ResponseBuilder contentLocation(URI location) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Response.ResponseBuilder tag(EntityTag tag) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Response.ResponseBuilder tag(String tag) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Response.ResponseBuilder lastModified(Date lastModified) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Response.ResponseBuilder expires(Date expires) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Response.ResponseBuilder header(String name, Object value) {
        this.headers.add(name, value);
        return this;
    }

    @Override
    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

