/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessControlException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.clerezza.jaxrs.extensions.HttpRequest;
import org.apache.clerezza.jaxrs.extensions.MethodResponse;
import org.apache.clerezza.jaxrs.extensions.ResourceMethodException;
import org.apache.clerezza.jaxrs.extensions.RootResourceExecutor;
import org.apache.clerezza.triaxrs.InjectionUtilities;
import org.apache.clerezza.triaxrs.JaxRsHandler;
import org.apache.clerezza.triaxrs.MethodDescriptor;
import org.apache.clerezza.triaxrs.ProcessableResponse;
import org.apache.clerezza.triaxrs.WebRequest;
import org.apache.clerezza.triaxrs.parameterinjectors.UnsupportedFieldType;
import org.apache.clerezza.triaxrs.util.AcceptHeader;
import org.apache.clerezza.triaxrs.util.MediaTypeComparator;
import org.apache.clerezza.triaxrs.util.MethodUtil;
import org.apache.clerezza.triaxrs.util.PathMatching;
import org.apache.clerezza.triaxrs.util.TemplateEncoder;
import org.apache.clerezza.triaxrs.util.URITemplate;
import org.apache.clerezza.utils.UriException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.wrhapi.HandlerException;
import org.wymiwyg.wrhapi.HeaderName;

public class RootResourceExecutorImpl
implements RootResourceExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RootResourceExecutorImpl.class);

    public MethodResponse execute(HttpRequest httpRequest, Object resource, String subResourcePath, Map<String, String> pathParams) throws ResourceMethodException {
        WebRequest request;
        try {
            request = (WebRequest)httpRequest;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Only Triaxrs HttpRequests supported");
        }
        try {
            AcceptHeader acceptHeader;
            HashMap<Method, Map<String, String>> method2PathParams = new HashMap<Method, Map<String, String>>();
            MethodsAndInstance candidateMethodsAndInstance = this.getCandidateMethods(request, resource, subResourcePath, method2PathParams, pathParams);
            Set<Method> candidateMethods = candidateMethodsAndInstance.methods;
            resource = candidateMethodsAndInstance.instance;
            org.wymiwyg.wrhapi.Method httpMethod = request.getWrhapiRequest().getMethod();
            Set<Method> httpMatchingMethods = MethodUtil.filterByHttpMethod(candidateMethods, httpMethod);
            if (httpMatchingMethods.size() == 0) {
                if (httpMethod.equals((Object)org.wymiwyg.wrhapi.Method.HEAD)) {
                    httpMatchingMethods = MethodUtil.filterByHttpMethod(candidateMethods, org.wymiwyg.wrhapi.Method.GET);
                }
                if (httpMethod.equals((Object)org.wymiwyg.wrhapi.Method.OPTIONS)) {
                    return this.responsDefaultOption(request, candidateMethods);
                }
            }
            if (httpMatchingMethods.size() == 0) {
                throw new WebApplicationException(405);
            }
            Set<MethodAndInputType> invocableMethods = this.filterByConsumedType(httpMatchingMethods, request);
            TreeSet<MethodAndConsumedAndProducibleTypes> acceptableMethods = new TreeSet<MethodAndConsumedAndProducibleTypes>(this.filterByAcceptHeader(invocableMethods, acceptHeader = request.getAcceptHeader()));
            if (acceptableMethods.size() == 0) {
                throw new WebApplicationException(406);
            }
            MethodAndConsumedAndProducibleTypes firstAcceptable = (MethodAndConsumedAndProducibleTypes)acceptableMethods.first();
            Method selectedMethod = firstAcceptable.method;
            Object methodReturnValue = this.handleWithMethod(request, (Map)method2PathParams.get(selectedMethod), resource, selectedMethod);
            return this.processReturnValue(methodReturnValue, selectedMethod, firstAcceptable.producibleTypes);
        }
        catch (UnsupportedFieldType ex) {
            throw new WebApplicationException(500);
        }
        catch (HandlerException ex) {
            throw new RuntimeException(ex);
        }
    }

    private MethodsAndInstance getCandidateMethods(WebRequest request, Object instance, String remainingPath, Map<Method, Map<String, String>> method2PathParams, Map<String, String> inheritedPathParams) throws HandlerException, UnsupportedFieldType {
        if (remainingPath.equals("/") || remainingPath.length() == 0) {
            Set<Method> result = this.getResourceMethods(instance.getClass());
            for (Method method : result) {
                method2PathParams.put(method, inheritedPathParams);
            }
            if (result.size() == 0) {
                return this.getSubResourceMethods(request, instance, remainingPath, method2PathParams, inheritedPathParams);
            }
            return new MethodsAndInstance(result, instance);
        }
        return this.getSubResourceMethods(request, instance, remainingPath, method2PathParams, inheritedPathParams);
    }

    private MethodsAndInstance getSubResourceMethods(WebRequest request, Object instance, String remainingPath, Map<Method, Map<String, String>> method2PathParams, Map<String, String> inheritedPathParams) throws HandlerException, UnsupportedFieldType {
        SortedSet<MethodDescriptor> methodDescriptors = this.getSubThingMethodDescriptors(instance.getClass());
        HashSet<Method> result = new HashSet<Method>();
        URITemplate uriTemplateOfFirstMatchingRM = null;
        HashMap<String, String> subPathParam = null;
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            URITemplate currentUriTemplate = methodDescriptor.getUriTemplate();
            if (uriTemplateOfFirstMatchingRM != null) {
                if (!uriTemplateOfFirstMatchingRM.equals(currentUriTemplate) || methodDescriptor.isSubResourceLocator()) break;
                result.add(methodDescriptor.getMethod());
                method2PathParams.put(methodDescriptor.getMethod(), subPathParam);
                continue;
            }
            PathMatching subPathMatching = currentUriTemplate.match(remainingPath);
            if (subPathMatching == null) continue;
            subPathParam = new HashMap<String, String>(inheritedPathParams);
            subPathParam.putAll(subPathMatching.getParameters());
            if (methodDescriptor.isSubResourceLocator()) {
                return this.getCandidateMethods(request, this.getSubResource(instance, methodDescriptor.getMethod(), request, subPathMatching), subPathMatching.getRemainingURIPath(), method2PathParams, subPathParam);
            }
            if (!subPathMatching.isSlashOrEmpty() || methodDescriptor.isSubResourceLocator()) continue;
            Method method = methodDescriptor.getMethod();
            result.add(method);
            uriTemplateOfFirstMatchingRM = currentUriTemplate;
            method2PathParams.put(method, subPathParam);
        }
        if (result.size() > 0) {
            return new MethodsAndInstance(result, instance);
        }
        throw new WebApplicationException(404);
    }

    private SortedSet<MethodDescriptor> getSubThingMethodDescriptors(Class<?> clazz) {
        TreeSet<MethodDescriptor> result = new TreeSet<MethodDescriptor>();
        Set<Method> methods = MethodUtil.getAnnotatedMethods(clazz);
        for (Method method : methods) {
            Path pathAnnotation = method.getAnnotation(Path.class);
            if (pathAnnotation == null) continue;
            result.add(new MethodDescriptor(method, this.templateUrlEncode(pathAnnotation.value())));
        }
        return result;
    }

    private Set<MethodAndInputType> filterByConsumedType(Set<Method> methods, WebRequest request) throws HandlerException {
        String contentTypeString = request.getHeaders().getFirst("Content-Type");
        MediaType mediaType = contentTypeString != null ? MediaType.valueOf(contentTypeString) : (request.getWrhapiRequest().getMessageBody() != null ? MediaType.APPLICATION_OCTET_STREAM_TYPE : null);
        HashSet<MethodAndInputType> result = new HashSet<MethodAndInputType>();
        block0: for (Method method : methods) {
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] parameterGenericTypes = method.getGenericParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (InjectionUtilities.isAnnotated(parameterAnnotations[i])) continue;
                if (mediaType == null) continue block0;
                Consumes consumes = method.getAnnotation(Consumes.class);
                TreeSet<MediaType> sortedConsumedType = new TreeSet<MediaType>(new MediaTypeComparator());
                if (consumes == null) {
                    sortedConsumedType.add(MediaType.WILDCARD_TYPE);
                } else {
                    for (String consumesString : consumes.value()) {
                        sortedConsumedType.add(MediaType.valueOf(consumesString));
                    }
                }
                for (MediaType consumedType : sortedConsumedType) {
                    if (!mediaType.isCompatible(consumedType)) continue;
                    result.add(new MethodAndInputType(method, consumedType));
                    continue block0;
                }
                MessageBodyReader<?> messageBodyReader = JaxRsHandler.providers.getMessageBodyReader(parameterTypes[i], parameterGenericTypes[i], parameterAnnotations[i], mediaType);
                if (messageBodyReader == null) continue block0;
            }
            result.add(new MethodAndInputType(method, null));
        }
        return result;
    }

    private Set<MethodAndConsumedAndProducibleTypes> filterByAcceptHeader(Set<MethodAndInputType> methodAndInputTypes, AcceptHeader acceptHeader) {
        HashSet<MethodAndConsumedAndProducibleTypes> result = new HashSet<MethodAndConsumedAndProducibleTypes>();
        for (MethodAndInputType methodAndInputType : methodAndInputTypes) {
            Produces produces = methodAndInputType.method.getAnnotation(Produces.class);
            HashSet<MediaType> producibleMediaTypes = new HashSet<MediaType>();
            if (produces == null) {
                result.add(new MethodAndConsumedAndProducibleTypes(methodAndInputType.method, methodAndInputType.consumedType, 0, producibleMediaTypes));
                continue;
            }
            int bestQValue = 0;
            for (String produced : produces.value()) {
                MediaType producedType = MediaType.valueOf(produced);
                int qValue = acceptHeader.getAcceptedQuality(producedType);
                if (qValue == 0) continue;
                if (qValue > bestQValue) {
                    bestQValue = qValue;
                }
                producibleMediaTypes.add(producedType);
            }
            if (producibleMediaTypes.size() <= 0) continue;
            result.add(new MethodAndConsumedAndProducibleTypes(methodAndInputType.method, methodAndInputType.consumedType, bestQValue, producibleMediaTypes));
        }
        return result;
    }

    private Object handleWithMethod(WebRequest request, Map<String, String> pathParams, Object instance, Method method) throws HandlerException, ResourceMethodException {
        Object methodReturnValue;
        Object[] methodParams;
        boolean encodingDisabled = instance.getClass().getAnnotation(Encoded.class) != null;
        try {
            methodParams = InjectionUtilities.createParametersForRequest(method, request, pathParams, JaxRsHandler.providers, encodingDisabled);
        }
        catch (UnsupportedFieldType ex) {
            logger.error("Exception {}", (Throwable)ex);
            throw new WebApplicationException(500);
        }
        try {
            methodReturnValue = method.invoke(instance, methodParams);
        }
        catch (IllegalAccessException ex) {
            logger.error("Exception {}", (Throwable)ex);
            throw new WebApplicationException(500);
        }
        catch (IllegalArgumentException ex) {
            logger.error("Exception {}", (Throwable)ex);
            throw new WebApplicationException(500);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof WebApplicationException) {
                throw (WebApplicationException)cause;
            }
            if (cause instanceof ResourceMethodException) {
                throw (ResourceMethodException)cause;
            }
            throw new ResourceMethodException(cause);
        }
        return methodReturnValue;
    }

    private ProcessableResponse processReturnValue(Object methodReturnValue, Method method, Set<MediaType> methodProducibleMediaTypes) throws HandlerException {
        Type genericMethodReturnType = method.getGenericReturnType();
        return ProcessableResponse.createProcessableResponse(methodReturnValue, method.getAnnotations(), methodProducibleMediaTypes, genericMethodReturnType, method);
    }

    private Set<Method> getResourceMethods(Class<?> clazz) {
        HashSet<Method> result = new HashSet<Method>();
        Set<Method> methods = MethodUtil.getAnnotatedMethods(clazz);
        for (Method method : methods) {
            if (method.getAnnotation(Path.class) != null || !MethodUtil.isResourceMethod(method)) continue;
            result.add(method);
        }
        return result;
    }

    private Object getSubResource(Object instance, Method method, WebRequest request, PathMatching pathMatching) throws HandlerException, UnsupportedFieldType {
        boolean encodingDisabled = instance.getClass().getAnnotation(Encoded.class) != null;
        Object[] paramValues = InjectionUtilities.createParametersForRequest(method, request, pathMatching.getParameters(), JaxRsHandler.providers, encodingDisabled);
        try {
            return method.invoke(instance, paramValues);
        }
        catch (IllegalAccessException ex) {
            logger.error("Exception {}", (Throwable)ex);
            throw new WebApplicationException(500);
        }
        catch (IllegalArgumentException ex) {
            logger.error("Exception {}", (Throwable)ex);
            throw new WebApplicationException(500);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof AccessControlException) {
                throw (AccessControlException)cause;
            }
            if (cause instanceof WebApplicationException) {
                throw (WebApplicationException)cause;
            }
            logger.error("Exception {}", (Throwable)ex);
            throw new WebApplicationException(500);
        }
    }

    private ProcessableResponse responsDefaultOption(WebRequest request, Set<Method> candidateMethods) {
        Response.ResponseBuilder builder = Response.ok();
        HashSet<String> supportedMethods = new HashSet<String>();
        for (Method candidateMethod : candidateMethods) {
            Annotation[] declaredAnnotations;
            for (Annotation annotation : declaredAnnotations = candidateMethod.getDeclaredAnnotations()) {
                HttpMethod httpMethod = annotation.annotationType().getAnnotation(HttpMethod.class);
                if (httpMethod == null) continue;
                supportedMethods.add(httpMethod.value());
            }
        }
        String allowHeader = this.concateNameWithComa(supportedMethods);
        builder.header(HeaderName.ALLOW.toString(), allowHeader);
        return ProcessableResponse.createProcessableResponse(builder.build(), null, null, null, null);
    }

    private String concateNameWithComa(Collection<String> collection) {
        if (collection.isEmpty()) {
            return "";
        }
        Iterator<String> iterator = collection.iterator();
        StringBuffer buffer = new StringBuffer(iterator.next());
        while (iterator.hasNext()) {
            buffer.append(", ");
            buffer.append(iterator.next());
        }
        return buffer.toString();
    }

    private String templateUrlEncode(String value) {
        try {
            return TemplateEncoder.encode(value, "utf-8");
        }
        catch (UriException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MethodAndConsumedAndProducibleTypes
    extends MethodAndInputType
    implements Comparable<MethodAndConsumedAndProducibleTypes> {
        private Set<MediaType> producibleTypes;
        private float highestQValueInAccept;

        private MethodAndConsumedAndProducibleTypes(Method method, MediaType consumedType, int highestQValueInAccept, Set<MediaType> producibleTypes) {
            super(method, consumedType);
            this.producibleTypes = producibleTypes;
            this.highestQValueInAccept = highestQValueInAccept;
        }

        @Override
        public int compareTo(MethodAndConsumedAndProducibleTypes o) {
            if (this.equals(o)) {
                return 0;
            }
            int consumedComparison = MediaTypeComparator.inconsistentCompare(this.consumedType, o.consumedType);
            if (consumedComparison != 0) {
                return consumedComparison;
            }
            if (this.highestQValueInAccept < o.highestQValueInAccept) {
                return 1;
            }
            if (this.highestQValueInAccept > o.highestQValueInAccept) {
                return -1;
            }
            if (this.getMaxConcreteness() > o.getMaxConcreteness()) {
                return 1;
            }
            if (this.getMaxConcreteness() < o.getMaxConcreteness()) {
                return -1;
            }
            return this.toString().compareTo(o.toString());
        }

        private int getMaxConcreteness() {
            int maxConcreteness = 0;
            for (MediaType producibleType : this.producibleTypes) {
                int contreteness = MediaTypeComparator.countWildChars(producibleType);
                if (contreteness <= maxConcreteness) continue;
                maxConcreteness = contreteness;
            }
            return maxConcreteness;
        }
    }

    private static class MethodAndInputType {
        Method method;
        MediaType consumedType;

        MethodAndInputType(Method method, MediaType consumedType) {
            this.method = method;
            this.consumedType = consumedType;
        }
    }

    private static class MethodsAndInstance {
        Set<Method> methods;
        Object instance;

        public MethodsAndInstance(Set<Method> methods, Object instance) {
            this.methods = methods;
            this.instance = instance;
        }
    }
}

