/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs;

import java.lang.reflect.Method;
import org.apache.clerezza.triaxrs.util.MethodUtil;
import org.apache.clerezza.triaxrs.util.URITemplate;

public class MethodDescriptor
implements Comparable<MethodDescriptor> {
    private Method method;
    private URITemplate uriTemplate;
    private boolean subResourceLocator;

    MethodDescriptor(Method method, String encodedPathTemplate) {
        this.method = method;
        this.uriTemplate = new URITemplate(encodedPathTemplate);
        this.subResourceLocator = !MethodUtil.isResourceMethod(method);
    }

    public Method getMethod() {
        return this.method;
    }

    public URITemplate getUriTemplate() {
        return this.uriTemplate;
    }

    boolean isSubResourceLocator() {
        return this.subResourceLocator;
    }

    @Override
    public int compareTo(MethodDescriptor o) {
        if (this.equals(o)) {
            return 0;
        }
        int uriCompare = this.uriTemplate.compareTo(o.uriTemplate);
        if (uriCompare != 0) {
            return uriCompare;
        }
        if (!this.subResourceLocator && o.subResourceLocator) {
            return -1;
        }
        if (this.subResourceLocator && !o.subResourceLocator) {
            return 1;
        }
        return this.method.toGenericString().compareTo(o.method.toGenericString());
    }

    public String toString() {
        return this.method.getName() + " at " + this.uriTemplate;
    }
}

