/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.triaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Providers;
import org.apache.clerezza.triaxrs.WebRequest;
import org.apache.clerezza.triaxrs.parameterinjectors.ContextInjector;
import org.apache.clerezza.triaxrs.parameterinjectors.CookieParameterInjector;
import org.apache.clerezza.triaxrs.parameterinjectors.FormParameterInjector;
import org.apache.clerezza.triaxrs.parameterinjectors.HeaderParameterInjector;
import org.apache.clerezza.triaxrs.parameterinjectors.MatrixParameterInjector;
import org.apache.clerezza.triaxrs.parameterinjectors.ParameterInjector;
import org.apache.clerezza.triaxrs.parameterinjectors.PathParameterInjector;
import org.apache.clerezza.triaxrs.parameterinjectors.QueryParameterInjector;
import org.apache.clerezza.triaxrs.parameterinjectors.UnsupportedFieldType;
import org.apache.clerezza.triaxrs.util.MethodUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.wrhapi.HandlerException;

public class InjectionUtilities {
    private static final Logger logger = LoggerFactory.getLogger(InjectionUtilities.class);
    private static Map<Class<? extends Annotation>, ParameterInjector> parameterInjectorMap = new HashMap<Class<? extends Annotation>, ParameterInjector>(){
        {
            this.put(MatrixParam.class, new MatrixParameterInjector());
            this.put(QueryParam.class, new QueryParameterInjector());
            this.put(PathParam.class, new PathParameterInjector());
            this.put(CookieParam.class, new CookieParameterInjector());
            this.put(HeaderParam.class, new HeaderParameterInjector());
            this.put(Context.class, new ContextInjector());
            this.put(FormParam.class, new FormParameterInjector());
        }
    };

    public static Object createPreparedInstance(WebRequest request, Map<String, String> pathParams, Providers providers, Class<?> resourceClass) throws HandlerException, UnsupportedFieldType {
        Object instance = null;
        boolean encodingDisabled = resourceClass.getAnnotation(Encoded.class) != null;
        Constructor<?>[] constructors = resourceClass.getConstructors();
        int countParameters = -1;
        Constructor<?> constructor = null;
        for (Constructor<?> c : constructors) {
            Class<?>[] parameters = c.getParameterTypes();
            int count = parameters.length;
            if (count <= countParameters) continue;
            constructor = c;
            countParameters = count;
        }
        if (constructor == null) {
            throw new HandlerException("No constructor found for resource class: " + resourceClass.getName());
        }
        logger.debug("Constructor found, injecting parameters...");
        Class<?>[] parameterClasses = constructor.getParameterTypes();
        boolean encodingDisabledForConstructor = encodingDisabled || constructor.getAnnotation(Encoded.class) != null;
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        Object[] parameters = new Object[parameterClasses.length];
        for (int i = 0; i < parameterClasses.length; ++i) {
            Object paramValue;
            Annotation[] as = parameterAnnotations[i];
            if (as.length == 0) {
                throw new HandlerException("Class has constructor with arguments we cannot unterstand: (the parameter of type " + parameterClasses[i] + " has no annotation)");
            }
            parameters[i] = paramValue = InjectionUtilities.getInjectionValueForAnnotation(request, pathParams, providers, as, parameterClasses[i], encodingDisabledForConstructor);
        }
        logger.debug("Calling constructor {} with parameters: {}", constructor, (Object)parameters);
        try {
            instance = constructor.newInstance(parameters);
        }
        catch (Exception e) {
            throw new HandlerException("Error in initializing: " + e, (Throwable)e);
        }
        InjectionUtilities.injectFields(request, pathParams, providers, instance);
        return instance;
    }

    private static int accessModifiers(int m) {
        return m & 7;
    }

    public static Object[] createParametersForRequest(Method method, WebRequest request, Map<String, String> pathParams, Providers providers, boolean encodingDisabled) throws HandlerException, UnsupportedFieldType {
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length == 0) {
            return new Object[0];
        }
        Type[] parameterTypes = method.getGenericParameterTypes();
        Class<?>[] parameterClasses = method.getParameterTypes();
        Object[] result = new Object[parameters.length];
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        boolean encodingDisabledForMethod = encodingDisabled || method.getAnnotation(Encoded.class) != null;
        for (int i = 0; i < parameters.length; ++i) {
            Annotation[] annotationsForThisParameter = parameterAnnotations[i];
            logger.debug("Parameter {} has annotations: {}", (Object)parameters[i].getName(), (Object)annotationsForThisParameter.length);
            if (annotationsForThisParameter == null || annotationsForThisParameter.length == 0) {
                result[i] = request.getBodyObject(parameterClasses[i], parameterTypes[i], null);
                continue;
            }
            Object injectedParameter = InjectionUtilities.getInjectionValueForAnnotation(request, pathParams, providers, annotationsForThisParameter, parameterTypes[i], encodingDisabledForMethod);
            logger.debug("Inject parameter {} to {}", (Object)i, injectedParameter);
            result[i] = injectedParameter;
        }
        return result;
    }

    private static Object getInjectionValueForAnnotation(WebRequest request, Map<String, String> pathParams, Providers providers, Annotation[] annotations, Type parameterType, boolean encodingDisabled) throws HandlerException, UnsupportedFieldType {
        String defaultValue = InjectionUtilities.getDefaultValue(annotations);
        Annotation injectionAnnotation = InjectionUtilities.getInjectionAnnotation(annotations);
        if (injectionAnnotation == null) {
            logger.debug("No injection annotation, do nothing: {}", (Object[])annotations);
            return null;
        }
        ParameterInjector parameterInjector = parameterInjectorMap.get(injectionAnnotation.annotationType());
        if (parameterInjector != null) {
            return parameterInjector.getValue(request, pathParams, providers, parameterType, injectionAnnotation, encodingDisabled, defaultValue);
        }
        logger.debug("Unknown annotation, do nothing: {}", (Object)annotations[0].getClass().getName());
        return null;
    }

    public static boolean isAnnotated(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!InjectionUtilities.isInjectionAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    private static Annotation getInjectionAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!InjectionUtilities.isInjectionAnnotation(annotation)) continue;
            return annotation;
        }
        return null;
    }

    private static String getDefaultValue(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(DefaultValue.class)) continue;
            DefaultValue dv = (DefaultValue)annotation;
            return dv.value();
        }
        return null;
    }

    public static void injectFields(WebRequest request, Map<String, String> pathParams, Providers providers, Object instance) throws HandlerException, UnsupportedFieldType {
        Class<?> resourceClass = instance.getClass();
        boolean encodingDisabled = resourceClass.getAnnotation(Encoded.class) != null;
        Field[] fields = resourceClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Annotation[] as = fields[i].getAnnotations();
            if (as.length == 0) continue;
            boolean encodingDisabledForField = encodingDisabled || fields[i].getAnnotation(Encoded.class) != null;
            Object fieldValue = InjectionUtilities.getInjectionValueForAnnotation(request, pathParams, providers, as, fields[i].getType(), encodingDisabledForField);
            if (fieldValue == null) continue;
            try {
                fields[i].set(instance, fieldValue);
            }
            catch (IllegalAccessException iae) {
                throw new HandlerException("setting " + fields[i] + " to " + fieldValue, (Throwable)iae);
            }
            logger.debug("set field value: {} to {}", (Object)fields[i], fieldValue);
        }
        logger.debug("Fields checked.");
        Iterator<Method> i$ = MethodUtil.getAnnotatedMethods(resourceClass).iterator();
        while (i$.hasNext()) {
            boolean modMatch;
            int searchMod = 1;
            Method method = i$.next();
            int mods = InjectionUtilities.accessModifiers(method.getModifiers());
            boolean bl = modMatch = searchMod == mods;
            if (!method.getName().startsWith("set") || !modMatch || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.TYPE)) continue;
            logger.debug("Method {} is a setter.", (Object)method);
            Annotation[] as = method.getAnnotations();
            if (as.length == 0) continue;
            boolean encodingDisabledForSetter = encodingDisabled || method.getAnnotation(Encoded.class) != null;
            Object value = InjectionUtilities.getInjectionValueForAnnotation(request, pathParams, providers, as, method.getGenericParameterTypes()[0], encodingDisabledForSetter);
            if (value == null) continue;
            Object[] valuesToSet = new Object[]{value};
            try {
                method.invoke(instance, valuesToSet);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new HandlerException((Throwable)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new HandlerException((Throwable)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new HandlerException((Throwable)invocationTargetException);
            }
        }
    }

    private static boolean isInjectionAnnotation(Annotation annotation) {
        return annotation.annotationType().equals(Context.class) || annotation.annotationType().equals(QueryParam.class) || annotation.annotationType().equals(FormParam.class) || annotation.annotationType().equals(MatrixParam.class) || annotation.annotationType().equals(PathParam.class) || annotation.annotationType().equals(CookieParam.class) || annotation.annotationType().equals(HeaderParam.class);
    }
}

