/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.storage.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.EntityAlreadyExistsException;
import org.apache.clerezza.rdf.core.access.NoSuchEntityException;
import org.apache.clerezza.rdf.core.access.TcProviderMultiplexer;
import org.apache.clerezza.rdf.core.access.WeightedTcProvider;
import org.apache.clerezza.rdf.core.impl.AbstractMGraph;
import org.apache.clerezza.rdf.core.serializedform.Parser;
import org.apache.clerezza.rdf.storage.web.Cache$;
import org.osgi.service.component.ComponentContext;
import org.slf4j.scala.DefaultLogger;
import org.slf4j.scala.Logging;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001=\u0011\u0001bV3c!J|\u00070\u001f\u0006\u0003\u0007\u0011\t1a^3c\u0015\t)a!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u001dA\u0011a\u0001:eM*\u0011\u0011BC\u0001\tG2,'/\u001a>{C*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u0019AA\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u00051\u0011mY2fgNT!!\b\u0004\u0002\t\r|'/Z\u0005\u0003?i\u0011!cV3jO\"$X\r\u001a+d!J|g/\u001b3feB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0006g\u000e\fG.\u0019\u0006\u0003K1\tQa\u001d7gi)L!a\n\u0012\u0003\u000f1{wmZ5oO\")\u0011\u0006\u0001C\u0001U\u00051A(\u001b8jiz\"\u0012a\u000b\t\u0003Y\u0001i\u0011A\u0001\u0005\b]\u0001\u0011\r\u0011\"\u00010\u0003EqW\r^<pe.$\u0016.\\3pkR\\U-_\u000b\u0002aA\u0011\u0011#M\u0005\u0003eI\u0011aa\u0015;sS:<\u0007B\u0002\u001b\u0001A\u0003%\u0001'\u0001\noKR<xN]6US6,w.\u001e;LKf\u0004\u0003\"\u0003\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u00038\u00039qW\r^<pe.$\u0016.\\3pkR,\u0012\u0001\u000f\t\u0003smj\u0011A\u000f\u0006\u0002G%\u0011AH\u000f\u0002\u0004\u0013:$\b\"\u0003 \u0001\u0001\u0004\u0005\r\u0011\"\u0003@\u0003IqW\r^<pe.$\u0016.\\3pkR|F%Z9\u0015\u0005\u0001\u001b\u0005CA\u001dB\u0013\t\u0011%H\u0001\u0003V]&$\bb\u0002#>\u0003\u0003\u0005\r\u0001O\u0001\u0004q\u0012\n\u0004B\u0002$\u0001A\u0003&\u0001(A\boKR<xN]6US6,w.\u001e;!\u0011\u001dA\u0005\u00011A\u0005\n%\u000b!\u0002^2Qe>4\u0018\u000eZ3s+\u0005Q\u0005CA\rL\u0013\ta%DA\u000bUGB\u0013xN^5eKJlU\u000f\u001c;ja2,\u00070\u001a:\t\u000f9\u0003\u0001\u0019!C\u0005\u001f\u0006qAo\u0019)s_ZLG-\u001a:`I\u0015\fHC\u0001!Q\u0011\u001d!U*!AA\u0002)CaA\u0015\u0001!B\u0013Q\u0015a\u0003;d!J|g/\u001b3fe\u0002BQ\u0001\u0016\u0001\u0005\u0012U\u000baCY5oI^+\u0017n\u001a5uK\u0012$6\r\u0015:pm&$WM\u001d\u000b\u0003\u0001ZCQaV*A\u0002a\t\u0001\u0002\u001d:pm&$WM\u001d\u0005\u00063\u0002!\tBW\u0001\u0019k:\u0014\u0017N\u001c3XK&<\u0007\u000e^3e)\u000e\u0004&o\u001c<jI\u0016\u0014HC\u0001!\\\u0011\u00159\u0006\f1\u0001\u0019\u0011\u0015i\u0006\u0001\"\u0005_\u0003!\t7\r^5wCR,GC\u0001!`\u0011\u0015\u0001G\f1\u0001b\u0003\u001d\u0019wN\u001c;fqR\u0004\"AY5\u000e\u0003\rT!\u0001Z3\u0002\u0013\r|W\u000e]8oK:$(B\u00014h\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001\u001b\u0007\u0002\t=\u001cx-[\u0005\u0003U\u000e\u0014\u0001cQ8na>tWM\u001c;D_:$X\r\u001f;\t\u000f1\u0004\u0001\u0019!C\u0005[\u00061\u0001/\u0019:tKJ,\u0012A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cr\tab]3sS\u0006d\u0017N_3eM>\u0014X.\u0003\u0002ta\n1\u0001+\u0019:tKJDq!\u001e\u0001A\u0002\u0013%a/\u0001\u0006qCJ\u001cXM]0%KF$\"\u0001Q<\t\u000f\u0011#\u0018\u0011!a\u0001]\"1\u0011\u0010\u0001Q!\n9\fq\u0001]1sg\u0016\u0014\b\u0005C\u0003|\u0001\u0011EA0\u0001\u0006cS:$\u0007+\u0019:tKJ$\"\u0001Q?\t\u000byT\b\u0019\u00018\u0002\u0003ADq!!\u0001\u0001\t#\t\u0019!\u0001\u0007v]\nLg\u000e\u001a)beN,'\u000fF\u0002A\u0003\u000bAQA`@A\u00029Dq!!\u0003\u0001\t\u0003\tY!A\u0005hKR<V-[4iiR\t\u0001\bC\u0004\u0002\u0010\u0001!\t!!\u0005\u0002\u0013\u001d,G/T$sCBDG\u0003BA\n\u00037\u0001B!!\u0006\u0002\u00185\tA$C\u0002\u0002\u001aq\u0011a!T$sCBD\u0007\u0002CA\u000f\u0003\u001b\u0001\r!a\b\u0002\t9\fW.\u001a\t\u0005\u0003+\t\t#C\u0002\u0002$q\u0011a!\u0016:j%\u00164\u0007bBA\u0014\u0001\u0011\u0005\u0011\u0011F\u0001\tO\u0016$xI]1qQR!\u00111FA\u0019!\u0011\t)\"!\f\n\u0007\u0005=BDA\u0003He\u0006\u0004\b\u000e\u0003\u0005\u0002\u001e\u0005\u0015\u0002\u0019AA\u0010\u0011\u001d\t)\u0004\u0001C\u0001\u0003o\t!bZ3u)JL\u0007\u000f\\3t)\u0011\tI$a\u0010\u0011\t\u0005U\u00111H\u0005\u0004\u0003{a\"\u0001\u0005+sSBdWmQ8mY\u0016\u001cG/[8o\u0011!\ti\"a\rA\u0002\u0005}\u0001bBA\"\u0001\u0011\u0005\u0011QI\u0001\rGJ,\u0017\r^3N\u000fJ\f\u0007\u000f\u001b\u000b\u0005\u0003'\t9\u0005\u0003\u0005\u0002\u001e\u0005\u0005\u0003\u0019AA\u0010\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001b\n1b\u0019:fCR,wI]1qQR1\u00111FA(\u0003#B\u0001\"!\b\u0002J\u0001\u0007\u0011q\u0004\u0005\t\u0003'\nI\u00051\u0001\u0002:\u00059AO]5qY\u0016\u001c\bbBA,\u0001\u0011\u0005\u0011\u0011L\u0001\u0017I\u0016dW\r^3Ue&\u0004H.Z\"pY2,7\r^5p]R\u0019\u0001)a\u0017\t\u0011\u0005u\u0011Q\u000ba\u0001\u0003?Aq!a\u0018\u0001\t\u0003\t\t'\u0001\u0005hKRt\u0015-\\3t)\u0011\t\u0019'a\u001c\u0011\r\u0005\u0015\u00141NA\u0010\u001b\t\t9GC\u0002\u0002jQ\tA!\u001e;jY&!\u0011QNA4\u0005\r\u0019V\r\u001e\u0005\t\u0003c\ni\u00061\u0001\u0002,\u0005)qM]1qQ\"9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0014!\u00067jgR$&/\u001b9mK\u000e{G\u000e\\3di&|gn\u001d\u000b\u0003\u0003GBq!a\u001f\u0001\t\u0003\t9(\u0001\u0006mSN$xI]1qQNDq!a \u0001\t\u0003\t9(A\u0006mSN$Xj\u0012:ba\"\u001c\bbBA\u0014\u0001\u0011\u0005\u00111\u0011\u000b\u0007\u0003W\t))a\"\t\u0011\u0005u\u0011\u0011\u0011a\u0001\u0003?A\u0001\"!#\u0002\u0002\u0002\u0007\u00111R\u0001\rkB$\u0017\r^3Q_2L7-\u001f\t\u0005\u0003\u001b\u000b\u0019JD\u0002-\u0003\u001fK1!!%\u0003\u0003\u0015\u0019\u0015m\u00195f\u0013\u0011\t)*a&\u0003\u000bY\u000bG.^3\n\u0007\u0005e%HA\u0006F]VlWM]1uS>t\u0007\"CAO\u0001!\u0015\r\u0011\"\u00030\u00031\t7mY3qi\"+\u0017\rZ3s\u0011%\t\t\u000b\u0001E\u0001B\u0003&\u0001'A\u0007bG\u000e,\u0007\u000f\u001e%fC\u0012,'\u000f\t")
public class WebProxy
implements WeightedTcProvider,
Logging {
    private final String networkTimeoutKey;
    private int networkTimeout;
    private TcProviderMultiplexer tcProvider;
    private Parser parser;
    private String acceptHeader;
    private final DefaultLogger logger;
    private volatile byte bitmap$0;

    private String acceptHeader$lzycompute() {
        WebProxy webProxy = this;
        synchronized (webProxy) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.acceptHeader = new StringBuilder().append((Object)((TraversableOnce)JavaConversions$.MODULE$.asScalaSet(this.parser().getSupportedFormats()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String f) {
                        String string;
                        String string2;
                        String string3 = string2 = f;
                        if (!("application/rdf+xml" != null ? !"application/rdf+xml".equals(string3) : string3 != null)) {
                            string = "1.0";
                        } else {
                            String string4 = string2;
                            if (!("text/rdf+n3" != null ? !"text/rdf+n3".equals(string4) : string4 != null)) {
                                string = "0.6";
                            } else {
                                String string5 = string2;
                                if (!("application/xhtml+xml" != null ? !"application/xhtml+xml".equals(string5) : string5 != null)) {
                                    string = "0.5";
                                } else {
                                    String string6 = string2;
                                    string = !("text/html" != null ? !"text/html".equals(string6) : string6 != null) ? "0.4" : "0.8";
                                }
                            }
                        }
                        String qualityOfFormat = string;
                        return new StringBuilder().append((Object)f).append((Object)"; q=").append((Object)qualityOfFormat).append((Object)",").toString();
                    }
                }, Set$.MODULE$.canBuildFrom())).mkString()).append((Object)" *; q=.1").toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.acceptHeader;
        }
    }

    private DefaultLogger logger$lzycompute() {
        WebProxy webProxy = this;
        synchronized (webProxy) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public DefaultLogger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String networkTimeoutKey() {
        return this.networkTimeoutKey;
    }

    private int networkTimeout() {
        return this.networkTimeout;
    }

    private void networkTimeout_$eq(int x$1) {
        this.networkTimeout = x$1;
    }

    private TcProviderMultiplexer tcProvider() {
        return this.tcProvider;
    }

    private void tcProvider_$eq(TcProviderMultiplexer x$1) {
        this.tcProvider = x$1;
    }

    public void bindWeightedTcProvider(WeightedTcProvider provider) {
        this.tcProvider().addWeightedTcProvider(provider);
    }

    public void unbindWeightedTcProvider(WeightedTcProvider provider) {
        this.tcProvider().removeWeightedTcProvider(provider);
    }

    public void activate(ComponentContext context) {
        this.networkTimeout_$eq(Integer.parseInt(context.getProperties().get(this.networkTimeoutKey()).toString()));
    }

    private Parser parser() {
        return this.parser;
    }

    private void parser_$eq(Parser x$1) {
        this.parser = x$1;
    }

    public void bindParser(Parser p) {
        this.parser_$eq(p);
    }

    public void unbindParser(Parser p) {
        this.parser_$eq(null);
    }

    public int getWeight() {
        return 0;
    }

    public MGraph getMGraph(UriRef name) {
        Graph graph = this.getGraph(name);
        return new AbstractMGraph(this, graph){
            private final Graph graph$1;

            public Iterator<Triple> performFilter(NonLiteral subject, UriRef predicate, Resource object) {
                return this.graph$1.filter(subject, predicate, object);
            }

            public int size() {
                return this.graph$1.size();
            }
            {
                this.graph$1 = graph$1;
            }
        };
    }

    public Graph getGraph(UriRef name) {
        try {
            return this.getGraph(name, Cache$.MODULE$.Fetch());
        }
        catch (IOException iOException) {
            this.logger().debug((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "could not get graph by dereferencing uri";
                }
            }, (Throwable)iOException);
            throw new NoSuchEntityException(name);
        }
    }

    public TripleCollection getTriples(UriRef name) {
        return this.getMGraph(name);
    }

    public MGraph createMGraph(UriRef name) {
        throw new UnsupportedOperationException();
    }

    public Graph createGraph(UriRef name, TripleCollection triples) {
        throw new UnsupportedOperationException();
    }

    public void deleteTripleCollection(UriRef name) {
        throw new UnsupportedOperationException();
    }

    public Set<UriRef> getNames(Graph graph) {
        ObjectRef result = new ObjectRef(new HashSet());
        JavaConversions$.MODULE$.asScalaSet(this.listGraphs()).foreach((Function1)new Serializable(this, graph, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebProxy $outer;
            private final Graph graph$2;
            private final ObjectRef result$1;

            public final Object apply(UriRef name) {
                return this.$outer.getGraph(name).equals(this.graph$2) ? BoxesRunTime.boxToBoolean((boolean)((Set)this.result$1.elem).add(name)) : BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.graph$2 = graph$2;
                this.result$1 = result$1;
            }
        });
        return (Set)result.elem;
    }

    public Set<UriRef> listTripleCollections() {
        HashSet<UriRef> result = new HashSet<UriRef>();
        result.addAll(this.listGraphs());
        result.addAll(this.listMGraphs());
        return result;
    }

    public Set<UriRef> listGraphs() {
        return Collections.emptySet();
    }

    public Set<UriRef> listMGraphs() {
        return Collections.emptySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Graph getGraph(UriRef name, Enumeration.Value updatePolicy) {
        this.logger().debug((Function0)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final UriRef name$1;

            public final String apply() {
                return new StringBuilder().append((Object)"getting graph ").append((Object)this.name$1).toString();
            }
            {
                this.name$1 = name$1;
            }
        });
        if (name.getUnicodeString().indexOf(35) != -1) {
            this.logger().debug((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "not dereferencing URI with hash sign. Please see CLEREZZA-533 for debate.";
                }
            });
            throw new NoSuchEntityException(name);
        }
        if (name.getUnicodeString().startsWith("urn")) {
            throw new NoSuchEntityException(name);
        }
        UriRef cacheGraphName = new UriRef(new StringBuilder().append((Object)"urn:x-localinstance:/cache/").append((Object)name.getUnicodeString()).toString());
        try {
            Graph graph;
            Graph graph2;
            Enumeration.Value value = updatePolicy;
            Enumeration.Value value2 = Cache$.MODULE$.Fetch();
            Enumeration.Value value3 = value;
            if (value2 != null ? !value2.equals(value3) : value3 != null) {
                Enumeration.Value value4 = Cache$.MODULE$.ForceUpdate();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    this.updateGraph$1(name, cacheGraphName);
                    graph2 = this.tcProvider().getGraph(cacheGraphName);
                    return graph2;
                } else {
                    Enumeration.Value value6 = Cache$.MODULE$.CacheOnly();
                    Enumeration.Value value7 = value;
                    if (value6 == null) {
                        if (value7 != null) {
                            throw new MatchError((Object)value);
                        }
                    } else if (!value6.equals(value7)) throw new MatchError((Object)value);
                    graph2 = this.tcProvider().getGraph(cacheGraphName);
                }
                return graph2;
            }
            try {
                graph = this.tcProvider().getGraph(cacheGraphName);
            }
            catch (NoSuchEntityException noSuchEntityException) {
                this.updateGraph$1(name, cacheGraphName);
                graph = this.tcProvider().getGraph(cacheGraphName);
            }
            graph2 = graph;
            return graph2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable cause = privilegedActionException.getCause();
            if (cause instanceof UnsupportedOperationException) {
                throw (UnsupportedOperationException)cause;
            }
            if (cause instanceof EntityAlreadyExistsException) {
                throw (EntityAlreadyExistsException)cause;
            }
            if (!(cause instanceof RuntimeException)) throw new RuntimeException(cause);
            throw (RuntimeException)cause;
        }
    }

    private String acceptHeader() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.acceptHeader$lzycompute() : this.acceptHeader;
    }

    private final void liftedTree1$1(UriRef cacheGraphName$1) {
        try {
            this.tcProvider().deleteTripleCollection(cacheGraphName$1);
        }
        catch (NoSuchEntityException noSuchEntityException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void updateGraph$1(UriRef name$1, UriRef cacheGraphName$1) {
        URL url = new URL(name$1.getUnicodeString());
        URLConnection connection = url.openConnection();
        URLConnection uRLConnection = connection;
        if (!(uRLConnection instanceof HttpURLConnection)) throw new MatchError((Object)uRLConnection);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.addRequestProperty("Accept", this.acceptHeader());
        httpURLConnection.setReadTimeout(this.networkTimeout());
        httpURLConnection.setConnectTimeout(this.networkTimeout());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        connection.connect();
        InputStream in = connection.getInputStream();
        String mediaType = connection.getContentType();
        Graph remoteTriples = this.parser().parse(in, mediaType, name$1);
        TcProviderMultiplexer tcProviderMultiplexer = this.tcProvider();
        synchronized (tcProviderMultiplexer) {
            this.liftedTree1$1(cacheGraphName$1);
            this.tcProvider().createGraph(cacheGraphName$1, (TripleCollection)remoteTriples);
            return;
        }
    }

    public WebProxy() {
        Logging.class.$init$((Logging)this);
        this.networkTimeoutKey = "network-timeout";
        this.tcProvider = new TcProviderMultiplexer();
        this.parser = null;
    }
}

