/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetAndDeleteContentTest
extends AbstractSessionTest {
    private static final String CONTENT1 = "one";
    private static final String CONTENT2 = "two";
    private static final String CONTENT3 = "three";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Set, Append, and Delete Content Test");
        this.setDescription("Creates a new document and tries to set, append, and delete its content.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (this.getContentStreamUpdatesCapbility(session) == CapabilityContentStreamUpdates.NONE) {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Stream updates are not supported. Test skipped!"));
            return;
        }
        try {
            CmisTestResultImpl f;
            Document doc;
            Folder testFolder = this.createTestFolder(session);
            Document workDoc = doc = this.createDocument(session, testFolder, "contenttest.txt", CONTENT1);
            DocumentTypeDefinition docType = (DocumentTypeDefinition)doc.getType();
            boolean checkedout = false;
            if (!doc.getAllowableActions().getAllowableActions().contains(Action.CAN_SET_CONTENT_STREAM)) {
                if (!docType.isVersionable().booleanValue()) {
                    this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "The test document does not accept a new content stream. Test skipped!"));
                    doc.delete(true);
                    return;
                }
                workDoc = (Document)session.getObject(doc.checkOut(), SELECT_ALL_NO_CACHE_OC);
                checkedout = true;
                if (!workDoc.getAllowableActions().getAllowableActions().contains(Action.CAN_SET_CONTENT_STREAM)) {
                    this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "The test PWC does not accept a new content stream. Test skipped!"));
                    workDoc.cancelCheckOut();
                    doc.delete(true);
                    return;
                }
            }
            if (docType.getContentStreamAllowed() == ContentStreamAllowed.REQUIRED) {
                this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "A content stream is required for this docuemnt type. deleteContentStream() test skipped!"));
            } else {
                try {
                    ObjectId newObjectId = workDoc.deleteContentStream(true);
                    Document contentDoc = this.getNewVersion(session, workDoc, checkedout, newObjectId, "deleteContentStream()");
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Document still has content after deleteContentStream() has been called!");
                    this.addResult(this.assertNull(contentDoc.getContentStream(), null, f));
                    workDoc = contentDoc;
                }
                catch (CmisNotSupportedException e) {
                    this.addResult(this.createResult(CmisTestResultStatus.WARNING, "deleteContentStream() is not supported!"));
                }
            }
            byte[] contentBytes = new byte[]{};
            try {
                contentBytes = CONTENT2.getBytes("UTF-8");
            }
            catch (Exception e) {
                // empty catch block
            }
            ContentStream contentStream = session.getObjectFactory().createContentStream(workDoc.getName(), (long)contentBytes.length, "text/plain", (InputStream)new ByteArrayInputStream(contentBytes));
            ObjectId newObjectId = workDoc.setContentStream(contentStream, true, true);
            try {
                contentStream.getStream().close();
            }
            catch (Exception e) {
                // empty catch block
            }
            Document contentDoc = this.getNewVersion(session, workDoc, checkedout, newObjectId, "setContentStream()");
            try {
                String content = this.getStringFromContentStream(contentDoc.getContentStream());
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document content doesn't match the content set by setContentStream()!");
                this.addResult(this.assertEquals(CONTENT2, content, null, (CmisTestResult)f));
            }
            catch (IOException e) {
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Document content couldn't be read! Exception: " + e.getMessage(), e, true));
            }
            if (session.getRepositoryInfo().getCmisVersion() != CmisVersion.CMIS_1_0) {
                contentBytes = new byte[]{};
                try {
                    contentBytes = CONTENT3.getBytes("UTF-8");
                }
                catch (Exception e) {
                    // empty catch block
                }
                contentStream = session.getObjectFactory().createContentStream(contentDoc.getName(), (long)contentBytes.length, "text/plain", (InputStream)new ByteArrayInputStream(contentBytes));
                newObjectId = contentDoc.appendContentStream(contentStream, true);
                Document contentDoc2 = this.getNewVersion(session, contentDoc, checkedout, newObjectId, "appendContentStream()");
                try {
                    String content = this.getStringFromContentStream(contentDoc2.getContentStream());
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Document content doesn't match the content set by setContentStream() followed by appendContentStream()!");
                    this.addResult(this.assertEquals("twothree", content, null, (CmisTestResult)f));
                }
                catch (IOException e) {
                    this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Document content couldn't be read! Exception: " + e.getMessage(), e, true));
                }
            }
            if (checkedout) {
                workDoc.cancelCheckOut();
            }
            this.deleteObject((CmisObject)doc);
        }
        finally {
            this.deleteTestFolder();
        }
    }

    private CapabilityContentStreamUpdates getContentStreamUpdatesCapbility(Session session) {
        if (session.getRepositoryInfo().getCapabilities() == null) {
            return null;
        }
        return session.getRepositoryInfo().getCapabilities().getContentStreamUpdatesCapability();
    }

    private Document getNewVersion(Session session, Document orgDoc, boolean checkedout, ObjectId newObjectId, String operation) {
        Document result = orgDoc;
        if (newObjectId != null) {
            if (!orgDoc.getId().equals(newObjectId.getId())) {
                if (checkedout) {
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, operation + " created a new version from a PWC!"));
                } else {
                    result = (Document)session.getObject(newObjectId, SELECT_ALL_NO_CACHE_OC);
                    this.addResult(this.checkObject(session, (CmisObject)result, this.getAllProperties((CmisObject)result), "Version created by " + operation + "  compliance"));
                }
            }
        } else {
            if (this.getBinding() != BindingType.ATOMPUB) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, operation + " did not return an object id!"));
            }
            if (!checkedout && Boolean.TRUE.equals(((DocumentTypeDefinition)orgDoc.getType()).isVersionable())) {
                List versions = orgDoc.getAllVersions();
                if (versions == null || versions.isEmpty()) {
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, operation + " created a new version but the version history is empty!"));
                } else if (!orgDoc.getId().equals(((Document)versions.get(0)).getId())) {
                    result = (Document)session.getObject((ObjectId)versions.get(0), SELECT_ALL_NO_CACHE_OC);
                    this.addResult(this.checkObject(session, (CmisObject)result, this.getAllProperties((CmisObject)result), "Version created by " + operation + " compliance"));
                }
            }
        }
        return result;
    }
}

