/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.basics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Types Test");
        this.setDescription("Checks all types exposed by the repository for specification compliance.");
    }

    @Override
    public void run(Session session) {
        CmisTestResultImpl failure;
        HashSet<String> cmisTypes = new HashSet<String>();
        cmisTypes.add(BaseTypeId.CMIS_DOCUMENT.value());
        cmisTypes.add(BaseTypeId.CMIS_FOLDER.value());
        cmisTypes.add(BaseTypeId.CMIS_RELATIONSHIP.value());
        cmisTypes.add(BaseTypeId.CMIS_POLICY.value());
        if (session.getRepositoryInfo().getCmisVersion() != CmisVersion.CMIS_1_0) {
            cmisTypes.add(BaseTypeId.CMIS_ITEM.value());
            cmisTypes.add(BaseTypeId.CMIS_SECONDARY.value());
        }
        for (TypeDefinition typeDef : session.getTypeChildren(null, false)) {
            String typeId = typeDef.getId();
            if (typeId == null || !cmisTypes.contains(typeId)) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Base type has an invalid id: " + typeId));
            }
            if (typeDef.getPropertyDefinitions() == null) continue;
            this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Property type definitions were not requested but delivered. Type id: " + typeId));
        }
        try {
            ObjectType documentType = session.getTypeDefinition(BaseTypeId.CMIS_DOCUMENT.value());
            this.addResult(this.checkTypeDefinition(session, (TypeDefinition)documentType, "Document type spec compliance."));
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Document type has the wrong base type: " + documentType.getBaseTypeId());
            this.addResult(this.assertEquals(BaseTypeId.CMIS_DOCUMENT, documentType.getBaseTypeId(), null, (CmisTestResult)failure));
        }
        catch (CmisObjectNotFoundException e) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Document type not available!", e, false));
        }
        try {
            ObjectType folderType = session.getTypeDefinition(BaseTypeId.CMIS_FOLDER.value());
            this.addResult(this.checkTypeDefinition(session, (TypeDefinition)folderType, "Folder type spec compliance."));
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Folder type has the wrong base type: " + folderType.getBaseTypeId());
            this.addResult(this.assertEquals(BaseTypeId.CMIS_FOLDER, folderType.getBaseTypeId(), null, (CmisTestResult)failure));
        }
        catch (CmisObjectNotFoundException e) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Folder type not available!", e, false));
        }
        try {
            ObjectType relationshipType = session.getTypeDefinition(BaseTypeId.CMIS_RELATIONSHIP.value());
            this.addResult(this.checkTypeDefinition(session, (TypeDefinition)relationshipType, "Relationship type spec compliance."));
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Relationship type has the wrong base type: " + relationshipType.getBaseTypeId());
            this.addResult(this.assertEquals(BaseTypeId.CMIS_RELATIONSHIP, relationshipType.getBaseTypeId(), null, (CmisTestResult)failure));
        }
        catch (CmisObjectNotFoundException e) {
            this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Relationship type not available!", e, false));
        }
        try {
            ObjectType policyType = session.getTypeDefinition(BaseTypeId.CMIS_POLICY.value());
            this.addResult(this.checkTypeDefinition(session, (TypeDefinition)policyType, "Policy type spec compliance."));
            failure = this.createResult(CmisTestResultStatus.FAILURE, "Policy type has the wrong base type: " + policyType.getBaseTypeId());
            this.addResult(this.assertEquals(BaseTypeId.CMIS_POLICY, policyType.getBaseTypeId(), null, (CmisTestResult)failure));
        }
        catch (CmisInvalidArgumentException e) {
            this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Policy type not available!", e, false));
        }
        catch (CmisObjectNotFoundException e) {
            this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Policy type not available!", e, false));
        }
        if (session.getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_1) {
            try {
                ObjectType itemType = session.getTypeDefinition(BaseTypeId.CMIS_ITEM.value());
                this.addResult(this.checkTypeDefinition(session, (TypeDefinition)itemType, "Item type spec compliance."));
                failure = this.createResult(CmisTestResultStatus.FAILURE, "Item type has the wrong base type: " + itemType.getBaseTypeId());
                this.addResult(this.assertEquals(BaseTypeId.CMIS_ITEM, itemType.getBaseTypeId(), null, (CmisTestResult)failure));
            }
            catch (CmisInvalidArgumentException e) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Item type not available!", e, false));
            }
            catch (CmisObjectNotFoundException e) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Item type not available!", e, false));
            }
            try {
                ObjectType secondaryType = session.getTypeDefinition(BaseTypeId.CMIS_SECONDARY.value());
                this.addResult(this.checkTypeDefinition(session, (TypeDefinition)secondaryType, "Secondary type spec compliance."));
                failure = this.createResult(CmisTestResultStatus.FAILURE, "Secondary type has the wrong base type: " + secondaryType.getBaseTypeId());
                this.addResult(this.assertEquals(BaseTypeId.CMIS_SECONDARY, secondaryType.getBaseTypeId(), null, (CmisTestResult)failure));
            }
            catch (CmisInvalidArgumentException e) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Secondary type not available!", e, false));
            }
            catch (CmisObjectNotFoundException e) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Secondary type not available!", e, false));
            }
        }
        int numOfTypes = this.runTypeChecks(session, session.getTypeDescendants(null, -1, true));
        this.addResult(this.createInfoResult("Checked " + numOfTypes + " type definitions."));
    }

    private int runTypeChecks(Session session, List<Tree<ObjectType>> types) {
        if (types == null) {
            return 0;
        }
        int numOfTypes = 0;
        for (Tree<ObjectType> tree : types) {
            CmisTestResultImpl failure = this.createResult(CmisTestResultStatus.FAILURE, "Types tree contains null leaf!");
            this.addResult(this.assertNotNull(tree, null, failure));
            if (tree == null) continue;
            ++numOfTypes;
            this.addResult(this.checkTypeDefinition(session, (TypeDefinition)tree.getItem(), "Type spec compliance: " + ((ObjectType)tree.getItem()).getId()));
            session.clear();
            try {
                ObjectType reloadedType = session.getTypeDefinition(((ObjectType)tree.getItem()).getId());
                this.addResult(this.checkTypeDefinition(session, (TypeDefinition)reloadedType, "Type spec compliance: " + (reloadedType == null ? "?" : reloadedType.getId())));
                failure = this.createResult(CmisTestResultStatus.FAILURE, "Type fetched via getTypeDescendants() is does not macth type fetched via getTypeDefinition(): " + ((ObjectType)tree.getItem()).getId());
                this.addResult(this.assertEquals((TypeDefinition)tree.getItem(), (TypeDefinition)reloadedType, (CmisTestResult)null, (CmisTestResult)failure));
            }
            catch (CmisObjectNotFoundException e) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Type fetched via getTypeDescendants() is not available via getTypeDefinition(): " + ((ObjectType)tree.getItem()).getId(), e, false));
            }
            session.clear();
            try {
                ItemIterable reloadedTypeChildren = session.getTypeChildren(((ObjectType)tree.getItem()).getId(), true);
                HashMap<String, ObjectType> typeChilden = new HashMap<String, ObjectType>();
                for (ObjectType childType : reloadedTypeChildren) {
                    this.addResult(this.checkTypeDefinition(session, (TypeDefinition)childType, "Type spec compliance: " + (childType == null ? "?" : childType.getId())));
                    if (childType == null) continue;
                    typeChilden.put(childType.getId(), childType);
                }
                if (tree.getChildren() == null) {
                    failure = this.createResult(CmisTestResultStatus.FAILURE, "Type children fetched via getTypeDescendants() don't match type children fetched via getTypeChildren(): " + ((ObjectType)tree.getItem()).getId());
                    this.addResult(this.assertEquals(0, typeChilden.size(), null, (CmisTestResult)failure));
                } else {
                    HashMap<String, Object> typeDescendants = new HashMap<String, Object>();
                    for (Tree childType : tree.getChildren()) {
                        if (childType == null || childType.getItem() == null) continue;
                        typeDescendants.put(((ObjectType)childType.getItem()).getId(), childType.getItem());
                    }
                    failure = this.createResult(CmisTestResultStatus.FAILURE, "Type children fetched via getTypeDescendants() don't match type children fetched via getTypeChildren(): " + ((ObjectType)tree.getItem()).getId());
                    this.addResult(this.assertEquals(typeDescendants.size(), typeChilden.size(), null, (CmisTestResult)failure));
                    for (ObjectType compareType : typeDescendants.values()) {
                        failure = this.createResult(CmisTestResultStatus.FAILURE, "Type fetched via getTypeDescendants() doesn't match type fetched via getTypeChildren(): " + ((ObjectType)tree.getItem()).getId());
                        this.addResult(this.assertEquals((TypeDefinition)compareType, (TypeDefinition)typeChilden.get(compareType.getId()), (CmisTestResult)null, (CmisTestResult)failure));
                    }
                }
            }
            catch (CmisObjectNotFoundException e) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Type children fetched via getTypeDescendants() is not available via getTypeChildren(): " + ((ObjectType)tree.getItem()).getId(), e, false));
            }
            numOfTypes += this.runTypeChecks(session, tree.getChildren());
        }
        return numOfTypes;
    }
}

