/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.report;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.report.AbstractCmisTestReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreHtmlReport
extends AbstractCmisTestReport {
    @Override
    public void createReport(Map<String, String> parameters, List<CmisTestGroup> groups, Writer writer) throws IOException {
        writer.write("<h1>OpenCMIS TCK Report</h1>\n");
        writer.write(new Date() + "\n");
        writer.write("\n<h2>Parameters</h2>\n");
        if (parameters != null) {
            writer.write("<table>\n");
            for (Map.Entry entry : new TreeMap<String, String>(parameters).entrySet()) {
                String value = (String)entry.getValue();
                if ("org.apache.chemistry.opencmis.password".endsWith((String)entry.getKey())) {
                    value = "*****";
                }
                writer.write("<tr><td>" + this.escape((String)entry.getKey()) + "</td><td>" + this.escape(value) + "</td></tr>\n");
            }
            writer.write("</table>\n");
        }
        writer.write("\n<h2>Groups</h2>\n");
        if (groups != null) {
            for (CmisTestGroup cmisTestGroup : groups) {
                this.printGroupResults(cmisTestGroup, writer);
            }
        }
        writer.flush();
    }

    public static void printStyle(Writer writer) throws IOException {
        writer.write("<style TYPE=\"text/css\">\n");
        writer.write(".tckResultINFO { margin-left: 5px; margin-right: 5px; }\n");
        writer.write(".tckResultSKIPPED { margin-left: 5px; margin-right: 5px; background-color: #FFFFFF; }\n");
        writer.write(".tckResultOK { margin-left: 5px; margin-right: 5px; background-color: #00FF00; }\n");
        writer.write(".tckResultWARNING { margin-left: 5px; margin-right: 5px; background-color: #FFFF00; }\n");
        writer.write(".tckResultFAILURE { margin-left: 5px; margin-right: 5px; background-color: #FF6000; }\n");
        writer.write(".tckResultUNEXPECTED_EXCEPTION { margin-left: 5px; margin-right: 5px; background-color: #FF0000; }\n");
        writer.write("</style>");
    }

    private void printGroupResults(CmisTestGroup group, Writer writer) throws IOException {
        if (!group.isEnabled()) {
            return;
        }
        writer.write("\n<hr>\n<h3>" + this.escape(group.getName()) + "</h3>\n");
        if (group.getDescription() != null) {
            writer.write("\n<p><i>" + this.escape(group.getDescription()) + "</i></p>\n");
        }
        if (group.getTests() != null) {
            for (CmisTest test : group.getTests()) {
                this.printTestResults(test, writer);
            }
        }
    }

    private void printTestResults(CmisTest test, Writer writer) throws IOException {
        if (!test.isEnabled()) {
            return;
        }
        writer.write("\n<h4>" + this.escape(test.getName()) + " (" + test.getTime() + " ms)</h4>\n");
        if (test.getDescription() != null) {
            writer.write("\n<p><i>" + this.escape(test.getDescription()) + "</i></p>\n");
        }
        if (test.getResults() != null) {
            for (CmisTestResult result : test.getResults()) {
                writer.write("<div style=\"padding: 5px;\">\n");
                this.printResult(result, writer);
                writer.write("</div>\n");
            }
        }
    }

    private void printResult(CmisTestResult result, Writer writer) throws IOException {
        writer.write("<div class=\"tckResult" + result.getStatus().name() + "\">\n");
        writer.write("<b>" + (Object)((Object)result.getStatus()) + "</b>: " + this.escape(result.getMessage()));
        if (result.getStackTrace() != null && result.getStackTrace().length > 0) {
            writer.write(" (" + this.escape(result.getStackTrace()[0].getFileName()) + ":" + result.getStackTrace()[0].getLineNumber() + ")");
        }
        writer.write("<br/>\n");
        if (result.getStatus() == CmisTestResultStatus.UNEXPECTED_EXCEPTION && result.getException() != null) {
            CmisBaseException cbe;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            result.getException().printStackTrace(pw);
            writer.write("\n<!--\nStacktrace:\n\n" + this.escape(((Object)sw).toString()) + "-->\n");
            if (result.getException() instanceof CmisBaseException && (cbe = (CmisBaseException)result.getException()).getErrorContent() != null) {
                writer.write("\n<!--\nError Content:\n\n" + this.escape(cbe.getErrorContent()) + "-->\n");
            }
        }
        for (CmisTestResult child : result.getChildren()) {
            this.printResult(child, writer);
        }
        writer.write("</div>\n");
    }

    protected String escape(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

