/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetAndDeleteContentTest
extends AbstractSessionTest {
    private static final String CONTENT1 = "one";
    private static final String CONTENT2 = "two";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Set and Delete content Test");
        this.setDescription("Creates a new document and tries to set and delete its content.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (this.getContentStreamUpdatesCapbility(session) == CapabilityContentStreamUpdates.NONE) {
            this.addResult(this.createInfoResult("Stream updates are not supported. Test skipped!"));
            return;
        }
        try {
            CmisTestResultImpl f;
            Document doc;
            Folder testFolder = this.createTestFolder(session);
            Document workDoc = doc = this.createDocument(session, testFolder, "contenttest.txt", CONTENT1);
            boolean checkedout = false;
            if (this.getContentStreamUpdatesCapbility(session) == CapabilityContentStreamUpdates.PWCONLY) {
                DocumentTypeDefinition docType = (DocumentTypeDefinition)doc.getType();
                if (!docType.isVersionable().booleanValue()) {
                    this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Content stream operations only work if PWCs and the the test type is not versionable. Test skipped!"));
                    doc.delete(true);
                    return;
                }
                workDoc = (Document)session.getObject(doc.checkOut(), SELECT_ALL_NO_CACHE_OC);
                checkedout = true;
            }
            try {
                workDoc.deleteContentStream(true);
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document still has content after deleteContentStream() has been called!");
                this.addResult(this.assertNull(workDoc.getContentStream(), null, f));
            }
            catch (CmisNotSupportedException e) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "deleteContentStream() is not supported!"));
            }
            byte[] contentBytes = new byte[]{};
            try {
                contentBytes = CONTENT2.getBytes("UTF-8");
            }
            catch (Exception e) {
                // empty catch block
            }
            ContentStreamImpl contentStream = new ContentStreamImpl(workDoc.getName(), BigInteger.valueOf(contentBytes.length), "text/plain", (InputStream)new ByteArrayInputStream(contentBytes));
            workDoc.setContentStream((ContentStream)contentStream, true, true);
            try {
                String content = this.getStringFromContentStream(workDoc.getContentStream());
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document content doesn't match the content set by setContentStream()!");
                this.addResult(this.assertEquals(CONTENT2, content, null, (CmisTestResult)f));
            }
            catch (IOException e) {
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Document content couldn't be read! Exception: " + e.getMessage(), e, true));
            }
            if (checkedout) {
                workDoc.cancelCheckOut();
            }
            this.deleteObject((CmisObject)doc);
        }
        finally {
            this.deleteTestFolder();
        }
    }

    private CapabilityContentStreamUpdates getContentStreamUpdatesCapbility(Session session) {
        if (session.getRepositoryInfo().getCapabilities() == null) {
            return null;
        }
        return session.getRepositoryInfo().getCapabilities().getContentStreamUpdatesCapability();
    }
}

