/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateAndDeleteDocumentTest
extends AbstractSessionTest {
    private static final String CONTENT = "TCK test content.";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Create and Delete Document Test");
        this.setDescription("Creates a few documents, checks the newly created documents and their parent and finally deletes the created documents.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        int numOfDocuments = 20;
        Folder testFolder = this.createTestFolder(session);
        try {
            CmisTestResultImpl f;
            HashMap<String, Document> documents = new HashMap<String, Document>();
            for (int i = 0; i < numOfDocuments; ++i) {
                Document newDocument = this.createDocument(session, testFolder, "doc" + i, CONTENT);
                documents.put(newDocument.getId(), newDocument);
            }
            this.addResult(this.checkChildren(session, testFolder, "Test folder children check"));
            ItemIterable children = testFolder.getChildren(SELECT_ALL_NO_CACHE_OC);
            ArrayList<String> childrenIds = new ArrayList<String>();
            for (CmisObject child : children) {
                if (child == null) continue;
                childrenIds.add(child.getId());
                Document document = (Document)documents.get(child.getId());
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document and test folder child don't match! Id: " + child.getId());
                this.addResult(this.assertShallowEquals((CmisObject)document, child, null, f));
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Number of created folders does not match the number of existing folders!");
            this.addResult(this.assertEquals(numOfDocuments, childrenIds.size(), null, (CmisTestResult)f));
            for (Document document : documents.values()) {
                if (childrenIds.contains(document.getId())) continue;
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Created document not found in test folder children! Id: " + document.getId()));
            }
            for (Document document : documents.values()) {
                ContentStream contentStream = document.getContentStream();
                if (contentStream != null) continue;
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Document has no content! Id: " + document.getId()));
            }
            for (Document document : documents.values()) {
                document.delete(true);
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document should not exist anymore but it is still there! Id: " + document.getId());
                this.addResult(this.assertIsFalse(this.exists((CmisObject)document), null, f));
            }
        }
        finally {
            this.deleteTestFolder();
        }
        this.addResult(this.createInfoResult("Tested the creation and deletion of " + numOfDocuments + " documents."));
    }
}

