/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.report;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.report.AbstractCmisTestReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextReport
extends AbstractCmisTestReport {
    public static String NL = System.getProperty("line.separator");

    @Override
    public void createReport(Map<String, String> parameters, List<CmisTestGroup> groups, Writer writer) throws IOException {
        writer.write("***************************************************************" + NL);
        writer.write("Test Report: " + new Date() + NL);
        writer.write("***************************************************************" + NL);
        if (parameters != null) {
            for (Map.Entry<String, String> p : new TreeMap<String, String>(parameters).entrySet()) {
                writer.write(p.getKey() + " = " + p.getValue() + NL);
            }
        }
        writer.write("***************************************************************" + NL);
        if (groups != null) {
            for (CmisTestGroup group : groups) {
                this.printGroupResults(group, writer);
            }
        }
        writer.flush();
    }

    private void printGroupResults(CmisTestGroup group, Writer writer) throws IOException {
        if (!group.isEnabled()) {
            return;
        }
        writer.write("===============================================================" + NL);
        writer.write(group.getName() + NL);
        writer.write("===============================================================" + NL);
        if (group.getTests() != null) {
            for (CmisTest test : group.getTests()) {
                this.printTestResults(test, writer);
            }
        }
    }

    private void printTestResults(CmisTest test, Writer writer) throws IOException {
        if (!test.isEnabled()) {
            return;
        }
        writer.write("---------------------------------------------------------------" + NL);
        writer.write(test.getName() + " (" + test.getTime() + " ms)" + NL);
        writer.write("---------------------------------------------------------------" + NL + NL);
        if (test.getResults() != null) {
            for (CmisTestResult result : test.getResults()) {
                this.printResult(1, result, writer);
                writer.write(NL);
            }
        }
        writer.write(NL);
    }

    private void printResult(int level, CmisTestResult result, Writer writer) throws IOException {
        this.printIntend(level, writer);
        writer.write((Object)((Object)result.getStatus()) + ": " + result.getMessage());
        if (result.getStackTrace() != null && result.getStackTrace().length > 0) {
            writer.write(" (" + result.getStackTrace()[0].getFileName() + ":" + result.getStackTrace()[0].getLineNumber() + ")");
        }
        writer.write(NL);
        if (result.getStatus() == CmisTestResultStatus.UNEXPECTED_EXCEPTION && result.getException() != null) {
            CmisBaseException cbe;
            writer.write(NL + "Stacktrace:" + NL + NL);
            result.getException().printStackTrace(new PrintWriter(writer));
            if (result.getException() instanceof CmisBaseException && (cbe = (CmisBaseException)result.getException()).getErrorContent() != null) {
                writer.write(NL + "Error Content:" + NL + NL);
                writer.write(cbe.getErrorContent());
            }
        }
        if (result.getException() != null) {
            this.printIntend(level, writer);
            writer.write("Exception: " + result.getException().getMessage() + NL);
        }
        if (result.getRequest() != null) {
            this.printIntend(level, writer);
            writer.write("Request: " + result.getRequest() + NL);
        }
        if (result.getRequest() != null) {
            this.printIntend(level, writer);
            writer.write("Response: " + result.getRequest() + NL);
        }
        for (CmisTestResult child : result.getChildren()) {
            this.printResult(level + 1, child, writer);
        }
    }

    private void printIntend(int x, Writer writer) throws IOException {
        for (int i = 0; i < x; ++i) {
            writer.write("  ");
        }
    }
}

