/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.report;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.report.AbstractCmisTestReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextReport
extends AbstractCmisTestReport {
    @Override
    public void createReport(Map<String, String> parameters, List<CmisTestGroup> groups, Writer writer) throws IOException {
        writer.write("***************************************************************\n");
        writer.write("Test Report: " + new Date() + "\n");
        writer.write("***************************************************************\n");
        if (parameters != null) {
            for (Map.Entry entry : new TreeMap<String, String>(parameters).entrySet()) {
                writer.write((String)entry.getKey() + " = " + (String)entry.getValue() + "\n");
            }
        }
        writer.write("***************************************************************\n");
        if (groups != null) {
            for (CmisTestGroup cmisTestGroup : groups) {
                this.printGroupResults(cmisTestGroup, writer);
            }
        }
        writer.flush();
    }

    private void printGroupResults(CmisTestGroup group, Writer writer) throws IOException {
        writer.write("===============================================================\n");
        writer.write(group.getName() + "\n");
        writer.write("===============================================================\n");
        if (group.getTests() != null) {
            for (CmisTest test : group.getTests()) {
                this.printTestResults(test, writer);
            }
        }
    }

    private void printTestResults(CmisTest test, Writer writer) throws IOException {
        writer.write("---------------------------------------------------------------\n");
        writer.write(test.getName() + " (" + test.getTime() + " ms)\n");
        writer.write("---------------------------------------------------------------\n\n");
        if (test.getResults() != null) {
            for (CmisTestResult result : test.getResults()) {
                this.printResult(1, result, writer);
                writer.write("\n");
            }
        }
        writer.write("\n");
    }

    private void printResult(int level, CmisTestResult result, Writer writer) throws IOException {
        this.printIntend(level, writer);
        writer.write((Object)((Object)result.getStatus()) + ": " + result.getMessage());
        if (result.getStackTrace() != null && result.getStackTrace().length > 0) {
            writer.write(" (" + result.getStackTrace()[0].getFileName() + ":" + result.getStackTrace()[0].getLineNumber() + ")");
        }
        writer.write("\n");
        if (result.getException() != null) {
            this.printIntend(level, writer);
            writer.write("Exception: " + result.getException().getMessage() + "\n");
        }
        if (result.getRequest() != null) {
            this.printIntend(level, writer);
            writer.write("Request: " + result.getRequest() + "\n");
        }
        if (result.getRequest() != null) {
            this.printIntend(level, writer);
            writer.write("Response: " + result.getRequest() + "\n");
        }
        for (CmisTestResult child : result.getChildren()) {
            this.printResult(level + 1, child, writer);
        }
    }

    private void printIntend(int x, Writer writer) throws IOException {
        for (int i = 0; i < x; ++i) {
            writer.write("  ");
        }
    }
}

