/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.runner;

import java.io.File;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestProgressMonitor;
import org.apache.chemistry.opencmis.tck.report.AbstractCmisTestReport;
import org.apache.chemistry.opencmis.tck.report.HtmlReport;
import org.apache.chemistry.opencmis.tck.report.TextReport;
import org.apache.chemistry.opencmis.tck.report.XmlReport;
import org.apache.chemistry.opencmis.tck.runner.AbstractRunner;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CmisTckAntTask
extends Task {
    private static final String REPORT_TEXT = "text";
    private static final String REPORT_XML = "xml";
    private static final String REPORT_HTML = "html";
    private static final String DEFAULT_REPORT_NAME = "cmis-tck-report";
    private File parameters;
    private File groups;
    private File output;
    private String format;

    public void init() throws BuildException {
        super.init();
        this.parameters = null;
        this.groups = null;
        this.output = null;
        this.format = REPORT_TEXT;
    }

    public void setParameters(File parameters) {
        this.parameters = parameters;
    }

    public void setGroups(File groups) {
        this.groups = groups;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void execute() throws BuildException {
        try {
            AntRunner runner = new AntRunner();
            if (this.parameters == null) {
                runner.setParameters(null);
            } else {
                runner.loadParameters(this.parameters);
            }
            if (this.groups == null) {
                runner.loadDefaultTckGroups();
            } else {
                runner.loadGroups(this.groups);
            }
            AbstractCmisTestReport report = null;
            if (this.format == null) {
                report = new TextReport();
                if (this.output == null) {
                    this.output = new File("cmis-tck-report.txt");
                }
            } else {
                this.format = this.format.trim().toLowerCase();
                if (REPORT_TEXT.equals(this.format)) {
                    report = new TextReport();
                    if (this.output == null) {
                        this.output = new File("cmis-tck-report.txt");
                    }
                } else if (REPORT_XML.equals(this.format)) {
                    report = new XmlReport();
                    if (this.output == null) {
                        this.output = new File("cmis-tck-report.xml");
                    }
                } else if (REPORT_HTML.equals(this.format)) {
                    report = new HtmlReport();
                    if (this.output == null) {
                        this.output = new File("cmis-tck-report.html");
                    }
                } else {
                    throw new Exception("Unknown format!");
                }
            }
            runner.run(new AntProgressMonitor());
            this.log("CMIS TCK Report: " + this.output.getAbsolutePath());
            report.createReport(runner.getParameters(), runner.getGroups(), this.output);
        }
        catch (Exception e) {
            throw new BuildException("OpenCMIS TCK run failed!", (Throwable)e);
        }
    }

    private class AntProgressMonitor
    implements CmisTestProgressMonitor {
        private AntProgressMonitor() {
        }

        public void startGroup(CmisTestGroup group) {
            CmisTckAntTask.this.log(group.getName() + " (" + group.getTests().size() + " tests)");
        }

        public void endGroup(CmisTestGroup group) {
        }

        public void startTest(CmisTest test) {
            CmisTckAntTask.this.log("  " + test.getName());
        }

        public void endTest(CmisTest test) {
        }

        public void message(String msg) {
            CmisTckAntTask.this.log(msg);
        }
    }

    private static class AntRunner
    extends AbstractRunner {
        private AntRunner() {
        }
    }
}

