/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractCmisTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;
import org.apache.chemistry.opencmis.tck.impl.FatalTestException;
import org.apache.chemistry.opencmis.tck.impl.PropertyCheckEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionTest
extends AbstractCmisTest {
    public static final OperationContext SELECT_ALL_NO_CACHE_OC = new OperationContextImpl();
    private SessionFactory factory = SessionFactoryImpl.newInstance();
    private Folder testFolder;

    public BindingType getBinding() {
        if (this.getParameters() == null) {
            return null;
        }
        try {
            return BindingType.fromValue((String)this.getParameters().get("org.apache.chemistry.opencmis.binding.spi.type"));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return super.getName() + " (" + this.getBinding() + ")";
    }

    @Override
    public void run() throws Exception {
        block2: {
            Map<String, String> parameters = this.getParameters();
            Session session = parameters.containsKey("org.apache.chemistry.opencmis.session.repository.id") ? this.factory.createSession(parameters) : ((Repository)this.factory.getRepositories(parameters).get(0)).createSession();
            session.getDefaultContext().setCacheEnabled(false);
            try {
                this.run(session);
            }
            catch (Exception e) {
                if (e instanceof FatalTestException) break block2;
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Exception: " + e.getMessage(), e, true));
            }
        }
    }

    public abstract void run(Session var1) throws Exception;

    protected RepositoryInfo getRepositoryInfo(Session session) {
        RepositoryInfo ri = session.getRepositoryInfo();
        CmisTestResultImpl failure = this.createResult(CmisTestResultStatus.FAILURE, "Repository info is null!", true);
        this.addResult(this.assertNotNull(ri, null, failure));
        return ri;
    }

    protected Folder createFolder(Folder parent, String name) {
        String objectTypeId = this.getParameters().get("org.apache.chemistry.opencmis.tck.default.folderType");
        if (objectTypeId == null) {
            objectTypeId = "cmis:folder";
        }
        return this.createFolder(parent, name, objectTypeId);
    }

    protected Folder createFolder(Folder parent, String name, String objectTypeId) {
        Folder result = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", objectTypeId);
        try {
            result = parent.createFolder(properties);
        }
        catch (CmisBaseException e) {
            this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Folder could not be created! Exception: " + e.getMessage(), e, true));
        }
        try {
            String[] propertiesToCheck = new String[result.getType().getPropertyDefinitions().size()];
            int i = 0;
            for (String propId : result.getType().getPropertyDefinitions().keySet()) {
                propertiesToCheck[i++] = propId;
            }
            this.addResult(this.checkObject((CmisObject)result, propertiesToCheck, "New folder object spec compliance"));
            List objectParents = result.getParents();
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Newly created folder has no or more than one parent! Id: " + result.getId(), true);
            this.addResult(this.assertEquals(1, objectParents.size(), null, (CmisTestResult)f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "First object parent of the newly created folder does not match parent! Id: " + result.getId(), true);
            this.assertShallowEquals((CmisObject)parent, (CmisObject)objectParents.get(0), null, f);
            Folder folderParent = result.getFolderParent();
            f = this.createResult(CmisTestResultStatus.FAILURE, "Newly created folder has no folder parent! Id: " + result.getId(), true);
            this.addResult(this.assertNotNull(folderParent, null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder parent of the newly created folder does not match parent! Id: " + result.getId(), true);
            this.assertShallowEquals((CmisObject)parent, (CmisObject)folderParent, null, f);
            boolean found = false;
            for (CmisObject child : parent.getChildren()) {
                if (child == null) {
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Parent folder contains a null child!", true));
                    continue;
                }
                if (!result.getId().equals(child.getId())) continue;
                found = true;
                f = this.createResult(CmisTestResultStatus.FAILURE, "Folder and parent child don't match! Id: " + result.getId(), true);
                this.assertShallowEquals((CmisObject)result, child, null, f);
                break;
            }
            if (!found) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Folder is not a child of the parent folder! Id: " + result.getId(), true));
            }
        }
        catch (CmisBaseException e) {
            this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Newly created folder is invalid! Exception: " + e.getMessage(), e, true));
        }
        return result;
    }

    protected void deleteObject(CmisObject object) {
        if (object != null) {
            if (object instanceof Folder) {
                try {
                    ((Folder)object).deleteTree(true, null, true);
                }
                catch (CmisBaseException e) {
                    this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Folder could not be deleted! Exception: " + e.getMessage(), e, true));
                }
            } else {
                try {
                    object.delete(true);
                }
                catch (CmisBaseException e) {
                    this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Object could not be deleted! Exception: " + e.getMessage(), e, true));
                }
            }
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Object should not exist anymore but it is still there! Id: " + object.getId(), true);
            this.addResult(this.assertIsFalse(this.exists(object), null, f));
        }
    }

    protected boolean exists(CmisObject object) {
        try {
            object.refresh();
            return true;
        }
        catch (CmisObjectNotFoundException e) {
            return false;
        }
    }

    protected Folder createTestFolder(Session session) {
        String testFolderParentPath = this.getParameters().get("org.apache.chemistry.opencmis.tck.default.testFolderParent");
        if (testFolderParentPath == null) {
            testFolderParentPath = "/";
        }
        String name = "cmistck" + System.currentTimeMillis() + session.getRepositoryInfo().hashCode();
        Folder parent = null;
        try {
            CmisObject parentObject = session.getObjectByPath(testFolderParentPath);
            if (!(parentObject instanceof Folder)) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Parent folder of the test folder is actually not a folder! Path: " + testFolderParentPath, true));
            }
            parent = (Folder)parentObject;
        }
        catch (CmisBaseException e) {
            this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Test folder could not be created! Exception: " + e.getMessage(), e, true));
        }
        this.testFolder = this.createFolder(parent, name);
        return this.testFolder;
    }

    protected Folder getTestFolder() {
        return this.testFolder;
    }

    protected void deleteTestFolder() {
        this.deleteObject((CmisObject)this.testFolder);
    }

    protected boolean isGetDescendantsSupported(Session session) {
        RepositoryCapabilities cap = session.getRepositoryInfo().getCapabilities();
        if (cap == null) {
            return false;
        }
        if (cap.isGetDescendantsSupported() == null) {
            return false;
        }
        return cap.isGetDescendantsSupported();
    }

    protected boolean isGetFolderTreeSupported(Session session) {
        RepositoryCapabilities cap = session.getRepositoryInfo().getCapabilities();
        if (cap == null) {
            return false;
        }
        if (cap.isGetFolderTreeSupported() == null) {
            return false;
        }
        return cap.isGetFolderTreeSupported();
    }

    protected CmisTestResult checkObject(CmisObject object, String[] properties, String message) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Object is null!", true);
        this.addResult(results, this.assertNotNull(object, null, f));
        if (object != null) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Object id is not set!");
            this.addResult(results, this.assertStringNotEmpty(object.getId(), null, f));
            for (String propId : properties) {
                Property prop = object.getProperty(propId);
                PropertyCheckEnum propertyCheck = PropertyCheckEnum.NO_VALUE_CHECK;
                if ("cmis:objectId".equals(propId) || "cmis:baseTypeId".equals(propId) || "cmis:objectTypeId".equals(propId) || "cmis:createdBy".equals(propId) || "cmis:lastModifiedBy".equals(propId) || "cmis:path".equals(propId) || "cmis:sourceId".equals(propId) || "cmis:targetId".equals(propId) || "cmis:policyText".equals(propId)) {
                    propertyCheck = PropertyCheckEnum.STRING_MUST_NOT_BE_EMPTY;
                }
                if ("cmis:name".equals(propId)) {
                    propertyCheck = PropertyCheckEnum.STRING_SHOULD_NOT_BE_EMPTY;
                }
                if ("cmis:creationDate".equals(propId) || "cmis:lastModificationDate".equals(propId) || "cmis:isImmutable".equals(propId)) {
                    propertyCheck = PropertyCheckEnum.MUST_BE_SET;
                }
                if ("cmis:parentId".equals(propId)) {
                    if (object instanceof Folder) {
                        propertyCheck = ((Folder)object).isRootFolder() ? PropertyCheckEnum.MUST_NOT_BE_SET : PropertyCheckEnum.STRING_MUST_NOT_BE_EMPTY;
                    } else {
                        this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Property cmis:parentId is only defined for folders!"));
                    }
                }
                this.addResult(results, this.checkProperty(prop, "Property " + propId, propertyCheck));
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Object has no CAN_GET_PROPERTIES allowable action!");
            this.addResult(results, this.assertAllowableAction(object, Action.CAN_GET_PROPERTIES, null, f));
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    protected CmisTestResult assertAllowableAction(CmisObject object, Action action, CmisTestResult success, CmisTestResult failure) {
        if (object.getAllowableActions() != null && object.getAllowableActions().getAllowableActions() != null && object.getAllowableActions().getAllowableActions().contains(action)) {
            return success;
        }
        return failure;
    }

    protected CmisTestResult assertNotAllowableAction(CmisObject object, Action action, CmisTestResult success, CmisTestResult failure) {
        if (object.getAllowableActions() != null && object.getAllowableActions().getAllowableActions() != null && !object.getAllowableActions().getAllowableActions().contains(action)) {
            return success;
        }
        return failure;
    }

    protected CmisTestResult checkProperty(Property<?> property, String message, PropertyCheckEnum propertyCheck) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Property is null!");
        this.addResult(results, this.assertNotNull(property, null, f));
        if (property != null) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Property id is not set or empty!");
            this.addResult(results, this.assertStringNotEmpty(property.getId(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Display name is not set!");
            this.addResult(results, this.assertNotNull(property.getDisplayName(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Query name is not set!");
            this.addResult(results, this.assertNotNull(property.getQueryName(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Local name is not set!");
            this.addResult(results, this.assertNotNull(property.getLocalName(), null, f));
            if (propertyCheck == PropertyCheckEnum.MUST_BE_SET || propertyCheck == PropertyCheckEnum.STRING_MUST_NOT_BE_EMPTY || propertyCheck == PropertyCheckEnum.STRING_SHOULD_NOT_BE_EMPTY) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Property has no value!");
                this.addResult(results, this.assertIsTrue(property.getValues().size() > 0, null, f));
            } else if (propertyCheck == PropertyCheckEnum.MUST_NOT_BE_SET) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Property has a value!");
                this.addResult(results, this.assertIsTrue(property.getValues().size() == 0, null, f));
            }
            boolean isString = property.getDefinition().getPropertyType() == PropertyType.STRING || property.getDefinition().getPropertyType() == PropertyType.ID || property.getDefinition().getPropertyType() == PropertyType.URI || property.getDefinition().getPropertyType() == PropertyType.HTML;
            for (Object value : property.getValues()) {
                if (value == null) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Property values contain a null value!"));
                    break;
                }
                if (!isString) continue;
                if (propertyCheck == PropertyCheckEnum.STRING_MUST_NOT_BE_EMPTY) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Property values contain an empty string!");
                    this.addResult(results, this.assertStringNotEmpty(value.toString(), null, f));
                    continue;
                }
                if (propertyCheck != PropertyCheckEnum.STRING_SHOULD_NOT_BE_EMPTY) continue;
                f = this.createResult(CmisTestResultStatus.WARNING, "Property values contain an empty string!");
                this.addResult(results, this.assertStringNotEmpty(value.toString(), null, f));
            }
            if (property.getDefinition().getCardinality() == Cardinality.SINGLE) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Property cardinality is SINGLE but property has more than one value!");
                this.addResult(results, this.assertIsTrue(property.getValues().size() <= 1, null, f));
            }
            if (property.getDefinition().isRequired() == null) {
                this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Property definition doesn't contain the required flag!!"));
            } else if (property.getDefinition().isRequired().booleanValue()) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Property is required but has no value!");
                this.addResult(results, this.assertIsTrue(property.getValues().size() > 0, null, f));
            }
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    protected CmisTestResult checkChildren(Session session, Folder folder, String message) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (folder == null) {
            return this.createResult(CmisTestResultStatus.FAILURE, "Folder is null!");
        }
        long childrenCount = 0L;
        long childrenFolderCount = 0L;
        ItemIterable children = folder.getChildren(SELECT_ALL_NO_CACHE_OC);
        for (CmisObject child : children) {
            ++childrenCount;
            if (child instanceof Folder) {
                ++childrenFolderCount;
            }
            this.checkChild(results, folder, child);
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.WARNING, "Number of children doesn't match the reported total number of items!");
        this.addResult(results, this.assertEquals(childrenCount, children.getTotalNumItems(), null, (CmisTestResult)f));
        if (this.isGetDescendantsSupported(session)) {
            long descendantsCount = 0L;
            List descendants = folder.getDescendants(1);
            for (Tree child : descendants) {
                ++descendantsCount;
                if (child == null) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Folder descendants contain a null tree!"));
                    continue;
                }
                this.checkChild(results, folder, (CmisObject)child.getItem());
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Number of descendants doesn't match the number of children returned by getChildren!");
            this.addResult(results, this.assertEquals(childrenCount, descendantsCount, null, (CmisTestResult)f));
        } else {
            this.addResult(results, this.createResult(CmisTestResultStatus.SKIPPED, "getDescendants is not supported."));
        }
        if (this.isGetFolderTreeSupported(session)) {
            long folderTreeCount = 0L;
            List folderTree = folder.getFolderTree(1);
            for (Tree child : folderTree) {
                ++folderTreeCount;
                if (child == null) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Folder tree contains a null tree!"));
                    continue;
                }
                this.checkChild(results, folder, (CmisObject)child.getItem());
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Number of folders doesn't match the number of folders returned by getChildren!");
            this.addResult(results, this.assertEquals(childrenFolderCount, folderTreeCount, null, (CmisTestResult)f));
        } else {
            this.addResult(results, this.createResult(CmisTestResultStatus.SKIPPED, "getFolderTree is not supported."));
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    private void checkChild(List<CmisTestResult> results, Folder folder, CmisObject child) {
        if (child == null) {
            this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Folder contains a null child!"));
        } else {
            String[] propertiesToCheck = new String[child.getType().getPropertyDefinitions().size()];
            int i = 0;
            for (String propId : child.getType().getPropertyDefinitions().keySet()) {
                propertiesToCheck[i++] = propId;
            }
            this.addResult(results, this.checkObject(child, propertiesToCheck, "Child check: " + child.getId()));
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Child is not fileable! Id: " + child.getId() + " / Type: " + child.getType().getId());
            this.addResult(results, this.assertIsTrue(child instanceof FileableCmisObject, null, f));
            if (child instanceof FileableCmisObject) {
                FileableCmisObject fileableChild = (FileableCmisObject)child;
                List parents = fileableChild.getParents();
                f = this.createResult(CmisTestResultStatus.FAILURE, "Child has no parents! Id: " + child.getId());
                this.addResult(results, this.assertIsTrue(parents.size() > 0, null, f));
                boolean foundParent = false;
                for (Folder parent : parents) {
                    if (parent == null) {
                        f = this.createResult(CmisTestResultStatus.FAILURE, "One of childs parents is null! Id: " + child.getId());
                        this.addResult(results, this.assertIsTrue(parents.size() > 0, null, f));
                    }
                    if (!folder.getId().equals(parent.getId())) continue;
                    foundParent = true;
                    break;
                }
                if (!foundParent) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Folder is not found in childs parents! Id: " + child.getId());
                    this.addResult(results, this.assertIsTrue(parents.size() > 0, null, f));
                }
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Child has no CAN_GET_OBJECT_PARENTS allowable action! Id: " + child.getId());
            this.addResult(results, this.assertAllowableAction(child, Action.CAN_GET_OBJECT_PARENTS, null, f));
            if (child instanceof Folder) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Child has no CAN_GET_FOLDER_PARENT allowable action! Id: " + child.getId());
                this.addResult(results, this.assertAllowableAction(child, Action.CAN_GET_FOLDER_PARENT, null, f));
            }
        }
    }

    protected CmisTestResult assertShallowEquals(CmisObject expected, CmisObject actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Expected object is null, but actual object is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Actual object is null, but expected object is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Ids don't match!");
        this.addResult(results, this.assertEquals(expected.getId(), actual.getId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Base types don't match!");
        this.addResult(results, this.assertEquals(expected.getBaseTypeId(), actual.getBaseTypeId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Types don't match!");
        this.addResult(results, this.assertEquals(expected.getType().getId(), actual.getType().getId(), null, (CmisTestResult)f));
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult checkTypeDefinition(Session session, TypeDefinition type, String message) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Type is null!");
        this.addResult(results, this.assertNotNull(type, null, f));
        if (type != null) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Type id is not set!");
            this.addResult(results, this.assertStringNotEmpty(type.getId(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Base type id is not set!");
            this.addResult(results, this.assertNotNull(type.getBaseTypeId(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Local name is not set!");
            this.addResult(results, this.assertStringNotEmpty(type.getLocalName(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Local namespace is not set!");
            this.addResult(results, this.assertStringNotEmpty(type.getLocalNamespace(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query name is not set!");
            this.addResult(results, this.assertStringNotEmpty(type.getQueryName(), null, f));
            if (type.getId() != null && type.getBaseTypeId() != null) {
                if (type.getBaseTypeId().value().equals(type.getId())) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Base type has parent type!");
                    this.addResult(results, this.assertNull(type.getParentTypeId(), null, f));
                } else {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Parent type is not set!");
                    this.addResult(results, this.assertStringNotEmpty(type.getParentTypeId(), null, f));
                }
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Creatable flag is not set!");
            this.addResult(results, this.assertNotNull(type.isCreatable(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Fileable flag is not set!");
            this.addResult(results, this.assertNotNull(type.isFileable(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Controllable ACL flag is not set!");
            this.addResult(results, this.assertNotNull(type.isControllableAcl(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Controllable Policy flag is not set!");
            this.addResult(results, this.assertNotNull(type.isControllablePolicy(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Fulltext indexed flag is not set!");
            this.addResult(results, this.assertNotNull(type.isFulltextIndexed(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Included in super type flag is not set!");
            this.addResult(results, this.assertNotNull(type.isIncludedInSupertypeQuery(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Queryable flag is not set!");
            this.addResult(results, this.assertNotNull(type.isQueryable(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Type display name is not set!");
            this.addResult(results, this.assertStringNotEmpty(type.getDisplayName(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Type description is not set!");
            this.addResult(results, this.assertStringNotEmpty(type.getDescription(), null, f));
            if (BaseTypeId.CMIS_DOCUMENT.equals((Object)type.getBaseTypeId())) {
                DocumentTypeDefinition docType = (DocumentTypeDefinition)type;
                f = this.createResult(CmisTestResultStatus.FAILURE, "Versionable flag is not set!");
                this.addResult(results, this.assertNotNull(docType.isVersionable(), null, f));
                f = this.createResult(CmisTestResultStatus.FAILURE, "Content stream allowed flag is not set!");
                this.addResult(results, this.assertNotNull(docType.getContentStreamAllowed(), null, f));
            } else if (!BaseTypeId.CMIS_FOLDER.equals((Object)type.getBaseTypeId())) {
                if (BaseTypeId.CMIS_RELATIONSHIP.equals((Object)type.getBaseTypeId())) {
                    RelationshipTypeDefinition relType = (RelationshipTypeDefinition)type;
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Allowed Source Type Ids are not set!");
                    this.addResult(results, this.assertNotNull(relType.getAllowedSourceTypeIds(), null, f));
                    if (relType.getAllowedSourceTypeIds() != null) {
                        for (String typeId : relType.getAllowedSourceTypeIds()) {
                            try {
                                session.getTypeDefinition(typeId);
                            }
                            catch (CmisObjectNotFoundException e) {
                                this.addResult(results, this.createResult(CmisTestResultStatus.WARNING, "Allowed Source Type Ids contain a type id that doesn't exist: " + typeId));
                            }
                        }
                    }
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Allowed Target Type Ids are not set!");
                    this.addResult(results, this.assertNotNull(relType.getAllowedTargetTypeIds(), null, f));
                    if (relType.getAllowedTargetTypeIds() != null) {
                        for (String typeId : relType.getAllowedTargetTypeIds()) {
                            try {
                                session.getTypeDefinition(typeId);
                            }
                            catch (CmisObjectNotFoundException e) {
                                this.addResult(results, this.createResult(CmisTestResultStatus.WARNING, "Allowed Target Type Ids contain a type id that doesn't exist: " + typeId));
                            }
                        }
                    }
                } else if (BaseTypeId.CMIS_POLICY.equals((Object)type.getBaseTypeId())) {
                    // empty if block
                }
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Type has no property definitions!");
            this.addResult(results, this.assertNotNull(type.getPropertyDefinitions(), null, f));
            if (type.getPropertyDefinitions() != null) {
                for (PropertyDefinition propDef : type.getPropertyDefinitions().values()) {
                    if (propDef == null) {
                        this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "A property definition is null!"));
                        continue;
                    }
                    if (propDef.getId() == null) {
                        this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "A property definition id is null!"));
                        continue;
                    }
                    this.addResult(results, this.checkPropertyDefinition(propDef, "Property definition: " + propDef.getId()));
                }
            }
            CmisPropertyDefintion cpd = new CmisPropertyDefintion("cmis:name", null, PropertyType.STRING, Cardinality.SINGLE, null, null, null);
            this.addResult(results, cpd.check(type));
            cpd = new CmisPropertyDefintion("cmis:objectId", false, PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, null, null);
            this.addResult(results, cpd.check(type));
            cpd = new CmisPropertyDefintion("cmis:baseTypeId", false, PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, null, null);
            this.addResult(results, cpd.check(type));
            cpd = new CmisPropertyDefintion("cmis:objectTypeId", false, PropertyType.ID, Cardinality.SINGLE, Updatability.ONCREATE, null, null);
            this.addResult(results, cpd.check(type));
            cpd = new CmisPropertyDefintion("cmis:createdBy", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, true, true);
            this.addResult(results, cpd.check(type));
            cpd = new CmisPropertyDefintion("cmis:creationDate", false, PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, true, true);
            this.addResult(results, cpd.check(type));
            cpd = new CmisPropertyDefintion("cmis:lastModifiedBy", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, true, true);
            this.addResult(results, cpd.check(type));
            cpd = new CmisPropertyDefintion("cmis:lastModificationDate", false, PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, true, true);
            this.addResult(results, cpd.check(type));
            cpd = new CmisPropertyDefintion("cmis:changeToken", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
            this.addResult(results, cpd.check(type));
            if (BaseTypeId.CMIS_DOCUMENT.equals((Object)type.getBaseTypeId())) {
                cpd = new CmisPropertyDefintion("cmis:isImmutable", false, PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:isLatestVersion", false, PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:isMajorVersion", false, PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:isLatestMajorVersion", false, PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:versionLabel", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:versionSeriesId", false, PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:isVersionSeriesCheckedOut", false, PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:versionSeriesCheckedOutBy", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:versionSeriesCheckedOutId", false, PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:checkinComment", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:contentStreamLength", false, PropertyType.INTEGER, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:contentStreamMimeType", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:contentStreamFileName", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:contentStreamId", false, PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
            } else if (BaseTypeId.CMIS_FOLDER.equals((Object)type.getBaseTypeId())) {
                cpd = new CmisPropertyDefintion("cmis:parentId", false, PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:path", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:allowedChildObjectTypeIds", false, PropertyType.ID, Cardinality.MULTI, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
            } else if (BaseTypeId.CMIS_RELATIONSHIP.equals((Object)type.getBaseTypeId())) {
                cpd = new CmisPropertyDefintion("cmis:sourceId", true, PropertyType.ID, Cardinality.SINGLE, null, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:targetId", true, PropertyType.ID, Cardinality.SINGLE, null, null, null);
                this.addResult(results, cpd.check(type));
            } else if (BaseTypeId.CMIS_POLICY.equals((Object)type.getBaseTypeId())) {
                cpd = new CmisPropertyDefintion("cmis:policyText", true, PropertyType.STRING, Cardinality.SINGLE, null, null, null);
                this.addResult(results, cpd.check(type));
            }
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    protected CmisTestResult checkPropertyDefinition(PropertyDefinition<?> propDef, String message) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Property definition is null!");
        this.addResult(results, this.assertNotNull(propDef, null, f));
        if (propDef != null) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Property id is not set!");
            this.addResult(results, this.assertStringNotEmpty(propDef.getId(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Local name is not set!");
            this.addResult(results, this.assertStringNotEmpty(propDef.getLocalName(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Local namespace is not set!");
            this.addResult(results, this.assertStringNotEmpty(propDef.getLocalNamespace(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query name is not set!");
            this.addResult(results, this.assertStringNotEmpty(propDef.getQueryName(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Display name is not set!");
            this.addResult(results, this.assertStringNotEmpty(propDef.getDisplayName(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Description is not set!");
            this.addResult(results, this.assertStringNotEmpty(propDef.getDescription(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Property type is not set!");
            this.addResult(results, this.assertNotNull(propDef.getPropertyType(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Cardinality is not set!");
            this.addResult(results, this.assertNotNull(propDef.getCardinality(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Updatability is not set!");
            this.addResult(results, this.assertNotNull(propDef.getUpdatability(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Inherited flag is not set!");
            this.addResult(results, this.assertNotNull(propDef.isInherited(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Required flag is not set!");
            this.addResult(results, this.assertNotNull(propDef.isRequired(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Queryable flag is not set!");
            this.addResult(results, this.assertNotNull(propDef.isQueryable(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Orderable flag is not set!");
            this.addResult(results, this.assertNotNull(propDef.isOrderable(), null, f));
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    protected CmisTestResult assertEquals(TypeDefinition expected, TypeDefinition actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Expected type defintion is null, but actual type defintion is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Actual type defintion is null, but expected type defintion is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Type ids don't match!");
        this.addResult(results, this.assertEquals(expected.getId(), actual.getId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Base type ids don't match!");
        this.addResult(results, this.assertEquals(expected.getBaseTypeId(), actual.getBaseTypeId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Parent type ids don't match!");
        this.addResult(results, this.assertEquals(expected.getParentTypeId(), actual.getParentTypeId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Query names don't match!");
        this.addResult(results, this.assertEquals(expected.getQueryName(), actual.getQueryName(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Local names don't match!");
        this.addResult(results, this.assertEquals(expected.getLocalName(), actual.getLocalName(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Local namespaces don't match!");
        this.addResult(results, this.assertEquals(expected.getLocalNamespace(), actual.getLocalNamespace(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Display names don't match!");
        this.addResult(results, this.assertEquals(expected.getDisplayName(), actual.getDisplayName(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Descriptions don't match!");
        this.addResult(results, this.assertEquals(expected.getDescription(), actual.getDescription(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Controllable ACl flags don't match!");
        this.addResult(results, this.assertEquals(expected.isControllableAcl(), actual.isControllableAcl(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Controllable Policy flags don't match!");
        this.addResult(results, this.assertEquals(expected.isControllablePolicy(), actual.isControllablePolicy(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Creatable flags don't match!");
        this.addResult(results, this.assertEquals(expected.isCreatable(), actual.isCreatable(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Fileable flags don't match!");
        this.addResult(results, this.assertEquals(expected.isFileable(), actual.isFileable(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Fulltext indexed flags don't match!");
        this.addResult(results, this.assertEquals(expected.isFulltextIndexed(), actual.isFulltextIndexed(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Queryable flags don't match!");
        this.addResult(results, this.assertEquals(expected.isQueryable(), actual.isQueryable(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Included in supertype query flags don't match!");
        this.addResult(results, this.assertEquals(expected.isIncludedInSupertypeQuery(), actual.isIncludedInSupertypeQuery(), null, (CmisTestResult)f));
        if (expected.getPropertyDefinitions() != null && actual.getPropertyDefinitions() != null) {
            Map epd = expected.getPropertyDefinitions();
            Map apd = actual.getPropertyDefinitions();
            f = this.createResult(CmisTestResultStatus.FAILURE, "Different number of property defintions!");
            this.addResult(results, this.assertEquals(epd.size(), apd.size(), null, (CmisTestResult)f));
            for (PropertyDefinition pd : epd.values()) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Property definition mismatch: " + pd.getId());
                this.addResult(results, this.assertEquals((PropertyDefinition<?>)pd, (PropertyDefinition<?>)((PropertyDefinition)apd.get(pd.getId())), (CmisTestResult)null, (CmisTestResult)f));
            }
        }
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult assertEquals(PropertyDefinition<?> expected, PropertyDefinition<?> actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Expected property defintion is null, but actual property defintion is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Actual property defintion is null, but expected property defintion is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Property ids don't match!");
        this.addResult(results, this.assertEquals(expected.getId(), actual.getId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Local names don't match!");
        this.addResult(results, this.assertEquals(expected.getLocalName(), actual.getLocalName(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Local namespaces don't match!");
        this.addResult(results, this.assertEquals(expected.getLocalNamespace(), actual.getLocalNamespace(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Display names don't match!");
        this.addResult(results, this.assertEquals(expected.getDisplayName(), actual.getDisplayName(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Query names don't match!");
        this.addResult(results, this.assertEquals(expected.getQueryName(), actual.getQueryName(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Property types don't match!");
        this.addResult(results, this.assertEquals(expected.getPropertyType(), actual.getPropertyType(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Cardinalities don't match!");
        this.addResult(results, this.assertEquals(expected.getCardinality(), actual.getCardinality(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Descriptions don't match!");
        this.addResult(results, this.assertEquals(expected.getDescription(), actual.getDescription(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Updatability flags don't match!");
        this.addResult(results, this.assertEquals(expected.getUpdatability(), actual.getUpdatability(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Default values don't match!");
        this.addResult(results, this.assertEqualLists(expected.getDefaultValue(), actual.getDefaultValue(), null, f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Inherited flags don't match!");
        this.addResult(results, this.assertEquals(expected.isInherited(), actual.isInherited(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Required flags don't match!");
        this.addResult(results, this.assertEquals(expected.isRequired(), actual.isRequired(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Queryable flags don't match!");
        this.addResult(results, this.assertEquals(expected.isQueryable(), actual.isQueryable(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Orderable flags don't match!");
        this.addResult(results, this.assertEquals(expected.isOrderable(), actual.isOrderable(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Open choice flags don't match!");
        this.addResult(results, this.assertEquals(expected.isOpenChoice(), actual.isOpenChoice(), null, (CmisTestResult)f));
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected void addResult(List<CmisTestResult> results, CmisTestResult result) {
        if (result != null) {
            if (result instanceof CmisTestResultImpl) {
                ((CmisTestResultImpl)result).setStackTrace(this.getStackTrace());
            }
            results.add(result);
            if (result.isFatal()) {
                throw new FatalTestException();
            }
        }
    }

    protected CmisTestResultStatus getWorst(List<CmisTestResult> results) {
        if (results == null || results.isEmpty()) {
            return CmisTestResultStatus.OK;
        }
        int max = 0;
        for (CmisTestResult result : results) {
            if (max >= result.getStatus().getLevel()) continue;
            max = result.getStatus().getLevel();
        }
        return CmisTestResultStatus.fromLevel(max);
    }

    static {
        SELECT_ALL_NO_CACHE_OC.setFilterString("*");
        SELECT_ALL_NO_CACHE_OC.setCacheEnabled(false);
        SELECT_ALL_NO_CACHE_OC.setIncludeAllowableActions(true);
        SELECT_ALL_NO_CACHE_OC.setIncludeAcls(true);
        SELECT_ALL_NO_CACHE_OC.setIncludePathSegments(true);
        SELECT_ALL_NO_CACHE_OC.setIncludePolicies(true);
        SELECT_ALL_NO_CACHE_OC.setRenditionFilterString("*");
    }

    public class CmisPropertyDefintion {
        private String id;
        private Boolean required;
        private PropertyType propertyType;
        private Cardinality cardinality;
        private Updatability updatability;
        private Boolean queryable;
        private Boolean orderable;

        public CmisPropertyDefintion(String id, Boolean required, PropertyType propertyType, Cardinality cardinality, Updatability updatability, Boolean queryable, Boolean orderable) {
            this.id = id;
            this.required = required;
            this.propertyType = propertyType;
            this.cardinality = cardinality;
            this.updatability = updatability;
            this.queryable = queryable;
            this.orderable = orderable;
        }

        public CmisTestResult check(TypeDefinition type) {
            ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
            Map propDefs = type.getPropertyDefinitions();
            if (propDefs == null) {
                AbstractSessionTest.this.addResult(results, AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Property definitions are missing!"));
            } else {
                PropertyDefinition propDef = (PropertyDefinition)propDefs.get(this.id);
                if (propDef == null) {
                    AbstractSessionTest.this.addResult(results, AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Property definition is missing!"));
                } else {
                    Boolean inherited;
                    CmisTestResultImpl f;
                    if (this.required != null && !this.required.equals(propDef.isRequired())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Required flag: expected: " + this.required + " / actual: " + propDef.isRequired());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                    if (!this.propertyType.equals((Object)propDef.getPropertyType())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Property type: expected: " + this.propertyType + " / actual: " + propDef.getPropertyType());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                    if (!this.cardinality.equals((Object)propDef.getCardinality())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Cardinality: expected: " + this.cardinality + " / actual: " + propDef.getCardinality());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                    if (this.updatability != null && !this.updatability.equals((Object)propDef.getUpdatability())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Updatability: expected: " + this.updatability + " / actual: " + propDef.getUpdatability());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                    if (this.queryable != null && !this.queryable.equals(propDef.isQueryable())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Queryable: expected: " + this.queryable + " / actual: " + propDef.isQueryable());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                    if (this.orderable != null && !this.orderable.equals(propDef.isOrderable())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Orderable: expected: " + this.orderable + " / actual: " + propDef.isOrderable());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                    if (type.getBaseTypeId() != null && !(inherited = Boolean.valueOf(!type.getBaseTypeId().value().equals(type.getId()))).equals(propDef.isInherited())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Inhertited: expected: " + inherited + " / actual: " + propDef.isInherited());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                }
            }
            CmisTestResultImpl result = AbstractSessionTest.this.createResult(AbstractSessionTest.this.getWorst(results), "Property definition: " + this.id);
            result.getChildren().addAll(results);
            return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
        }
    }
}

