/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class SecondaryTypesTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Secondary Types Test");
        this.setDescription("Creates documents, attaches and detaches secondary types, checks the properties, and finally deletes the test documents.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (session.getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Secondary types are not supported by CMIS 1.0. Test skipped!"));
            return;
        }
        if (!this.hasSecondaries(session)) {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Repository doesn't support secondary types. Test skipped!"));
            return;
        }
        ObjectType docType = session.getTypeDefinition(this.getDocumentTestTypeId());
        PropertyDefinition secTypesPropDef = (PropertyDefinition)docType.getPropertyDefinitions().get("cmis:secondaryObjectTypeIds");
        if (secTypesPropDef == null) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Test document type has no cmis:secondaryObjectTypeIds property!"));
            return;
        }
        if (secTypesPropDef.getUpdatability() != Updatability.READWRITE) {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Test document type does not allow attaching secondary types. Test skipped!"));
            return;
        }
        Folder testFolder = this.createTestFolder(session);
        try {
            String secondaryTestTypeId = this.getSecondaryTestTypeId();
            ObjectType secondaryTestType = session.getTypeDefinition(secondaryTestTypeId);
            this.createDocumentAndAttachSecondaryType(session, testFolder, secondaryTestType);
            this.createDocumentWithSecondaryType(session, testFolder, secondaryTestType);
        }
        finally {
            this.deleteTestFolder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDocumentAndAttachSecondaryType(Session session, Folder testFolder, ObjectType secondaryTestType) {
        Document doc;
        Document workDoc = doc = this.createDocument(session, testFolder, "createandattach.txt", "Secondary Type Test");
        try {
            boolean checkedout = false;
            if (this.needsCheckOut(doc)) {
                workDoc = (Document)session.getObject(doc.checkOut(), SELECT_ALL_NO_CACHE_OC);
                checkedout = true;
            }
            ArrayList<String> secondaryTypes = new ArrayList<String>();
            if (workDoc.getSecondaryTypes() != null) {
                for (SecondaryType secType : workDoc.getSecondaryTypes()) {
                    secondaryTypes.add(secType.getId());
                }
            }
            secondaryTypes.add(secondaryTestType.getId());
            HashMap<String, ArrayList<String>> properties = new HashMap<String, ArrayList<String>>();
            properties.put("cmis:secondaryObjectTypeIds", secondaryTypes);
            CmisObject newId = workDoc.updateProperties(properties);
            Document newDoc = (Document)session.getObject((ObjectId)newId, SELECT_ALL_NO_CACHE_OC);
            boolean found = this.checkSecondaryType(newDoc, secondaryTestType);
            if (found) {
                this.detachSecondaryType(session, newDoc, secondaryTestType);
            }
            if (checkedout) {
                workDoc.cancelCheckOut();
            }
        }
        finally {
            this.deleteObject((CmisObject)doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDocumentWithSecondaryType(Session session, Folder testFolder, ObjectType secondaryTestType) {
        Document doc = this.createDocument(session, testFolder, "createwithsecondarytype.txt", this.getDocumentTestTypeId(), new String[]{secondaryTestType.getId()}, "Secondary Type Test");
        try {
            boolean found = this.checkSecondaryType(doc, secondaryTestType);
            if (found && !this.needsCheckOut(doc)) {
                this.detachSecondaryType(session, doc, secondaryTestType);
            }
        }
        finally {
            this.deleteObject((CmisObject)doc);
        }
    }

    private boolean needsCheckOut(Document doc) {
        DocumentTypeDefinition type = (DocumentTypeDefinition)doc.getType();
        PropertyDefinition secTypeIdsPropDef = (PropertyDefinition)type.getPropertyDefinitions().get("cmis:secondaryObjectTypeIds");
        return secTypeIdsPropDef.getUpdatability() == Updatability.WHENCHECKEDOUT || !doc.getAllowableActions().getAllowableActions().contains(Action.CAN_UPDATE_PROPERTIES) && Boolean.TRUE.equals(type.isVersionable());
    }

    private boolean checkSecondaryType(Document doc, ObjectType secondaryTestType) {
        CmisTestResultImpl f;
        boolean found = false;
        if (doc.getSecondaryTypes() == null) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Document does not have the attached secondary type!"));
        } else {
            for (SecondaryType secType : doc.getSecondaryTypes()) {
                if (!secondaryTestType.getId().equals(secType.getId())) continue;
                found = true;
                break;
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Document does not have the attached secondary type!");
            this.addResult(this.assertIsTrue(found, null, f));
        }
        if (found) {
            HashSet<String> secondaryTypeProperties = new HashSet<String>();
            if (secondaryTestType.getPropertyDefinitions() != null) {
                for (PropertyDefinition propDef : secondaryTestType.getPropertyDefinitions().values()) {
                    secondaryTypeProperties.add(propDef.getId());
                }
            }
            for (Property prop : doc.getProperties()) {
                secondaryTypeProperties.remove(prop.getId());
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Documents lacks the following secondary type properties: " + secondaryTypeProperties);
            this.addResult(this.assertIsTrue(secondaryTypeProperties.isEmpty(), null, f));
        }
        return found;
    }

    private void detachSecondaryType(Session session, Document doc, ObjectType secondaryTestType) {
        ArrayList<String> secondaryTypesId = new ArrayList<String>();
        for (SecondaryType secType : doc.getSecondaryTypes()) {
            if (secondaryTestType.getId().equals(secType.getId())) continue;
            secondaryTypesId.add(secType.getId());
        }
        HashMap<String, ArrayList<String>> properties = new HashMap<String, ArrayList<String>>();
        properties.put("cmis:secondaryObjectTypeIds", secondaryTypesId);
        CmisObject newId = doc.updateProperties(properties);
        Document newDoc = (Document)session.getObject((ObjectId)newId, SELECT_ALL_NO_CACHE_OC);
        boolean found = false;
        if (newDoc.getSecondaryTypes() != null) {
            for (SecondaryType secType : newDoc.getSecondaryTypes()) {
                if (!secondaryTestType.getId().equals(secType.getId())) continue;
                found = true;
                break;
            }
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Document still has the detached secondary type!");
        this.addResult(this.assertIsFalse(found, null, f));
        ObjectType primaryType = newDoc.getType();
        List secondaryTypes = newDoc.getSecondaryTypes();
        for (Property prop : doc.getProperties()) {
            if (primaryType.getPropertyDefinitions().containsKey(prop.getId())) continue;
            f = this.createResult(CmisTestResultStatus.FAILURE, "Property '" + prop.getId() + "' is neither defined by the primary type nor by a secondary type!");
            if (secondaryTypes == null) {
                this.addResult(f);
                continue;
            }
            boolean foundProperty = false;
            for (SecondaryType secondaryType : secondaryTypes) {
                if (secondaryType.getPropertyDefinitions() == null || !secondaryType.getPropertyDefinitions().containsKey(prop.getId())) continue;
                foundProperty = true;
                break;
            }
            this.addResult(this.assertIsTrue(foundProperty, null, f));
        }
    }
}

