/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.query;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.QueryStatement;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;
import org.apache.chemistry.opencmis.tck.tests.query.AbstractQueryTest;

public class QueryForObject
extends AbstractQueryTest {
    private static final String CONTENT = "TCK test content.";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Query For Object Test");
        this.setDescription("Creates a folder and a document, queries them by object id, and deletes both.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (this.supportsQuery(session) && !this.isFulltextOnly(session)) {
            Folder testFolder = this.createTestFolder(session);
            try {
                Document document = this.createDocument(session, testFolder, "testdoc.txt", CONTENT);
                this.runFolderQuery(session, testFolder);
                this.runDocumentQuery(session, document);
                document.delete(true);
            }
            finally {
                this.deleteTestFolder();
            }
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Metadata query not supported. Test Skipped!"));
        }
    }

    public void runFolderQuery(Session session, Folder testFolder) {
        QueryStatement[] statements;
        if (!Boolean.TRUE.equals(testFolder.getType().isQueryable())) {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Folder type '" + testFolder.getType().getId() + "' is not queryable. Folder query test skipped!"));
            return;
        }
        for (QueryStatement statement : statements = new QueryStatement[]{session.createQueryStatement("SELECT * FROM ? WHERE ? = ?"), session.createQueryStatement("SELECT * FROM ? WHERE ? IN (?)")}) {
            CmisTestResultImpl f;
            statement.setType(1, testFolder.getType());
            statement.setProperty(2, (PropertyDefinition)testFolder.getType().getPropertyDefinitions().get("cmis:objectId"));
            statement.setString(3, new String[]{testFolder.getId()});
            this.addResult(this.createInfoResult("Folder query: " + statement.toQueryString()));
            int count = 0;
            for (QueryResult qr : statement.query(false)) {
                ++count;
                String objectId = (String)qr.getPropertyValueByQueryName("cmis:objectId");
                f = this.createResult(CmisTestResultStatus.FAILURE, "Folder query returned unexpected object. Id: " + objectId);
                this.addResult(this.assertEquals(testFolder.getId(), objectId, null, (CmisTestResult)f));
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder query should return exactly one hit, but returned " + count + ".");
            this.addResult(this.assertEquals(1, count, null, (CmisTestResult)f));
        }
    }

    public void runDocumentQuery(Session session, Document testDocument) {
        QueryStatement[] statements;
        if (!Boolean.TRUE.equals(testDocument.getType().isQueryable())) {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Document type '" + testDocument.getType().getId() + "' is not queryable. Document query test skipped!"));
            return;
        }
        for (QueryStatement statement : statements = new QueryStatement[]{session.createQueryStatement("SELECT * FROM ? WHERE ? = ?"), session.createQueryStatement("SELECT * FROM ? WHERE ? IN (?)")}) {
            CmisTestResultImpl f;
            statement.setType(1, testDocument.getType());
            statement.setProperty(2, (PropertyDefinition)testDocument.getType().getPropertyDefinitions().get("cmis:objectId"));
            statement.setString(3, new String[]{testDocument.getId()});
            this.addResult(this.createInfoResult("Document query: " + statement.toQueryString()));
            int count = 0;
            for (QueryResult qr : statement.query(false)) {
                ++count;
                String objectId = (String)qr.getPropertyValueByQueryName("cmis:objectId");
                f = this.createResult(CmisTestResultStatus.FAILURE, "Document query returned unexpected object. Id: " + objectId);
                this.addResult(this.assertEquals(testDocument.getId(), objectId, null, (CmisTestResult)f));
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Document query should return exactly one hit, but returned " + count + ".");
            this.addResult(this.assertEquals(1, count, null, (CmisTestResult)f));
        }
    }
}

