/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.query;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.ChangeEvent;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class ContentChangesSmokeTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Content Changes Smoke Test");
        this.setDescription("Calls getContentChanges(). It does not check if the results are correct!");
    }

    @Override
    public void run(Session session) {
        if (this.supportsContentChanges(session)) {
            ChangeEvents events = session.getContentChanges(null, true, 1000L, SELECT_ALL_NO_CACHE_OC);
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Change events are null!");
            this.addResult(this.assertNotNull(events, null, f));
            if (events != null && events.getChangeEvents() != null) {
                if (this.getBinding() != BindingType.ATOMPUB) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Change log token is null!");
                    this.addResult(this.assertNotNull(events.getLatestChangeLogToken(), null, f));
                } else {
                    CmisTestResultImpl ocs = this.createResult(CmisTestResultStatus.INFO, "Change log token is null. The AtomPub binding does not return it.");
                    CmisTestResultImpl nocs = this.createResult(CmisTestResultStatus.INFO, "Change log token is not null. Probably an OpenCMIS based server.");
                    this.addResult(this.assertNull(events.getLatestChangeLogToken(), ocs, nocs));
                }
                for (ChangeEvent event : events.getChangeEvents()) {
                    this.checkChangeEvent(session, event);
                }
            }
            for (ChangeEvent event : session.getContentChanges(null, true, SELECT_ALL_NO_CACHE_OC)) {
                this.checkChangeEvent(session, event);
            }
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Content Changes not supported. Test Skipped!"));
        }
    }

    protected boolean supportsContentChanges(Session session) {
        RepositoryInfo repository = session.getRepositoryInfo();
        if (repository.getCapabilities().getChangesCapability() == null) {
            return false;
        }
        return repository.getCapabilities().getChangesCapability() != CapabilityChanges.NONE;
    }

    protected void checkChangeEvent(Session session, ChangeEvent event) {
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Object Id is not set!");
        this.addResult(this.assertStringNotEmpty(event.getObjectId(), null, f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Change Type is not set! Id: " + event.getObjectId());
        this.addResult(this.assertNotNull(event.getChangeType(), null, f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Change Time is not set! Id: " + event.getObjectId());
        this.addResult(this.assertNotNull(event.getChangeTime(), null, f));
        if (event.getObjectId() != null) {
            if (event.getChangeType() == ChangeType.DELETED) {
                try {
                    session.getObject(event.getObjectId(), SELECT_ALL_NO_CACHE_OC);
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Change event indicates that an object has been deleted but it still exists. Id: " + event.getObjectId()));
                }
                catch (CmisObjectNotFoundException e) {}
            } else {
                try {
                    CmisObject object = session.getObject(event.getObjectId(), SELECT_ALL_NO_CACHE_OC);
                    this.addResult(this.checkObject(session, object, this.getAllProperties(object), "Object check. Id: " + event.getObjectId()));
                }
                catch (CmisObjectNotFoundException e) {
                    // empty catch block
                }
            }
        }
    }
}

