/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.math.BigInteger;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PartialContentStream;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class ContentRangesTest
extends AbstractSessionTest {
    private static final String CONTENT = "0123456789012345678901234567890";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Content Ranges Test");
        this.setDescription("Creates a document and reads different excerpts of the content.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        Folder testFolder = this.createTestFolder(session);
        Document doc = null;
        try {
            CmisTestResultImpl f;
            String excerpt;
            ContentStream content;
            doc = this.createDocument(session, testFolder, "testcontent.txt", CONTENT);
            long contentLength = doc.getContentStreamLength();
            try {
                content = doc.getContentStream(null, null);
                excerpt = this.getStringFromContentStream(content);
                if (contentLength > -1L && content.getLength() > -1L) {
                    f = this.createResult(CmisTestResultStatus.WARNING, "Content length does not match {offset=null, length=null}!", false);
                    this.addResult(this.assertEquals(contentLength, content.getLength(), null, (CmisTestResult)f));
                }
                if (CONTENT.equals(excerpt)) {
                    this.addResult(this.assertIsFalse(content instanceof PartialContentStream, null, this.createResult(CmisTestResultStatus.FAILURE, "Retrieved stream is marked as partial stream although the full stream {offset=null, length=null} was expected!")));
                } else {
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Retrieved stream doesn't match the document content!"));
                }
            }
            catch (Exception e) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Unexpected exception while retrieving full stream {offset=null, length=null}: " + e, e, false));
            }
            try {
                content = doc.getContentStream(BigInteger.ZERO, null);
                excerpt = this.getStringFromContentStream(content);
                if (contentLength > -1L && content.getLength() > -1L) {
                    f = this.createResult(CmisTestResultStatus.WARNING, "Content length does not match {offset=0, length=null}!", false);
                    this.addResult(this.assertEquals(contentLength, content.getLength(), null, (CmisTestResult)f));
                }
                if (CONTENT.equals(excerpt)) {
                    this.addResult(this.assertIsFalse(content instanceof PartialContentStream, null, this.createResult(CmisTestResultStatus.WARNING, "Retrieved stream is marked as partial stream although the full stream {offset=0, length=null} was expected!")));
                } else {
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Retrieved stream doesn't match the document content!"));
                }
            }
            catch (Exception e) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Unexpected exception while retrieving full stream {offset=0, length=null}: " + e, e, false));
            }
            try {
                content = doc.getContentStream(BigInteger.valueOf(3L), null);
                excerpt = this.getStringFromContentStream(content);
                if (contentLength > -1L && content.getLength() > -1L) {
                    f = this.createResult(CmisTestResultStatus.WARNING, "Content length does not match {offset=3, length=null}!", false);
                    this.addResult(this.assertEquals(contentLength - 3L, content.getLength(), null, (CmisTestResult)f));
                }
                if (CONTENT.equals(excerpt)) {
                    this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Retrieved full stream instead of an excerpt {offset=3, length=null}! Content ranges supported?"));
                    this.addResult(this.assertIsFalse(content instanceof PartialContentStream, null, this.createResult(CmisTestResultStatus.WARNING, "Retrieved stream is marked as partial stream, although the full stream is returned!")));
                } else {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Retrieved stream excerpt {offset=3, length=null} doesn't match!");
                    this.addResult(this.assertEquals(CONTENT.substring(3), excerpt, null, (CmisTestResult)f));
                    this.addResult(this.assertIsTrue(content instanceof PartialContentStream, null, this.createResult(CmisTestResultStatus.WARNING, "Retrieved stream is not marked as partial stream. (AtomPub and Browser Binding should return the HTTP status code 206.)")));
                }
            }
            catch (Exception e) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Unexpected exception while retrieving stream {offset=3, length=null}: " + e, e, false));
            }
            try {
                content = doc.getContentStream(null, BigInteger.valueOf(12L));
                excerpt = this.getStringFromContentStream(content);
                if (content.getLength() > -1L) {
                    f = this.createResult(CmisTestResultStatus.WARNING, "Content length does not match {offset=null, length=12}!", false);
                    this.addResult(this.assertEquals(12L, content.getLength(), null, (CmisTestResult)f));
                }
                if (CONTENT.equals(excerpt)) {
                    this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Retrieved full stream instead of an excerpt {offset=null, length=12}! Content ranges supported?"));
                    this.addResult(this.assertIsFalse(content instanceof PartialContentStream, null, this.createResult(CmisTestResultStatus.WARNING, "Retrieved stream is marked as partial stream, although the full stream is returned!")));
                } else {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Retrieved stream excerpt {offset=null, length=12} doesn't match!");
                    this.addResult(this.assertEquals(CONTENT.substring(0, 12), excerpt, null, (CmisTestResult)f));
                    this.addResult(this.assertIsTrue(content instanceof PartialContentStream, null, this.createResult(CmisTestResultStatus.WARNING, "Retrieved stream is not marked as partial stream. (AtomPub and Browser Binding should return the HTTP status code 206.)")));
                }
            }
            catch (Exception e) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Unexpected exception while retrieving stream {offset=null, length=12}: " + e, e, false));
            }
            try {
                content = doc.getContentStream(BigInteger.valueOf(5L), BigInteger.valueOf(17L));
                excerpt = this.getStringFromContentStream(content);
                if (content.getLength() > -1L) {
                    f = this.createResult(CmisTestResultStatus.WARNING, "Content length does not match {offset=5, length=17}!", false);
                    this.addResult(this.assertEquals(12L, content.getLength(), null, (CmisTestResult)f));
                }
                if (CONTENT.equals(excerpt)) {
                    this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Retrieved full stream instead of an excerpt {offset=5, length=17}! Content ranges supported?"));
                    this.addResult(this.assertIsFalse(content instanceof PartialContentStream, null, this.createResult(CmisTestResultStatus.WARNING, "Retrieved stream is marked as partial stream, although the full stream is returned!")));
                } else {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Retrieved stream excerpt {offset=5, length=17} doesn't match!");
                    this.addResult(this.assertEquals(CONTENT.substring(5, 22), excerpt, null, (CmisTestResult)f));
                    this.addResult(this.assertIsTrue(content instanceof PartialContentStream, null, this.createResult(CmisTestResultStatus.WARNING, "Retrieved stream is not marked as partial stream. (AtomPub and Browser Binding should return the HTTP status code 206.)")));
                }
            }
            catch (Exception e) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Unexpected exception while retrieving stream {offset=5, length=17}: " + e, e, false));
            }
            try {
                content = doc.getContentStream(BigInteger.valueOf(9L), BigInteger.valueOf(123L));
                excerpt = this.getStringFromContentStream(content);
                if (content.getLength() > -1L) {
                    f = this.createResult(CmisTestResultStatus.WARNING, "Content length does not match {offset=9, length=123}!", false);
                    this.addResult(this.assertEquals(CONTENT.length() - 9, content.getLength(), null, (CmisTestResult)f));
                }
                if (CONTENT.equals(excerpt)) {
                    this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Retrieved full stream instead of an excerpt {offset=9, length=123}! Content ranges supported?"));
                    this.addResult(this.assertIsFalse(content instanceof PartialContentStream, null, this.createResult(CmisTestResultStatus.WARNING, "Retrieved stream is marked as partial stream, although the full stream is returned!")));
                } else {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Retrieved stream excerpt {offset=9, length=123} doesn't match!");
                    this.addResult(this.assertEquals(CONTENT.substring(9), excerpt, null, (CmisTestResult)f));
                    this.addResult(this.assertIsTrue(content instanceof PartialContentStream, null, this.createResult(CmisTestResultStatus.WARNING, "Retrieved stream is not marked as partial stream. (AtomPub and Browser Binding should return the HTTP status code 206.)")));
                }
            }
            catch (Exception e) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Unexpected exception while retrieving stream {offset=9, length=123}: " + e, e, false));
            }
        }
        catch (Throwable throwable) {
            this.deleteObject((CmisObject)doc);
            this.deleteTestFolder();
            throw throwable;
        }
        this.deleteObject((CmisObject)doc);
        this.deleteTestFolder();
    }
}

