/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.query;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;
import org.apache.chemistry.opencmis.tck.tests.query.AbstractQueryTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryLikeTest
extends AbstractQueryTest {
    private static final String CONTENT = "TCK test content.";
    private static final int PAGE_SIZE = 10;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Query LIKE Test");
        this.setDescription("Performs a LIKE query and checks if only matching objects are returned.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (this.supportsQuery(session) && !this.isFulltextOnly(session)) {
            Folder testFolder = this.createTestFolder(session);
            try {
                for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                    this.createDocument(session, testFolder, c + "Document", CONTENT);
                    this.createFolder(session, testFolder, c + "Folder");
                }
                OperationContext context = session.createOperationContext();
                context.setFilterString("cmis:name,cmis:creationDate");
                context.setCacheEnabled(false);
                context.setIncludeAcls(false);
                context.setIncludeAllowableActions(false);
                context.setIncludePathSegments(false);
                context.setIncludePolicies(false);
                context.setIncludeRelationships(IncludeRelationships.NONE);
                context.setRenditionFilterString("cmis:none");
                context.setOrderBy("cmis:creationDate");
                for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                    CmisTestResultImpl f;
                    long timestamp = Long.MIN_VALUE;
                    long count = 0L;
                    for (CmisObject o : session.queryObjects("cmis:document", "cmis:name LIKE '" + c + "%'", false, context).getPage(10)) {
                        if (o.getName() == null || o.getName().length() == 0) {
                            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Documents without name should not be returned by this query! Document ID: " + o.getId()));
                        } else {
                            f = this.createResult(CmisTestResultStatus.FAILURE, "Document name should start with '" + c + "' but the name is '" + o.getName() + "'.");
                            this.addResult(this.assertEquals(Character.valueOf(c), Character.valueOf(Character.toLowerCase(o.getName().charAt(0))), null, (CmisTestResult)f));
                        }
                        if (o.getCreationDate() == null) {
                            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Found document without creation date! Document ID: " + o.getId()));
                        } else {
                            f = this.createResult(CmisTestResultStatus.FAILURE, "Query results should be ordered by cmis:creationDate but they are not!");
                            this.addResult(this.assertIsTrue(timestamp <= o.getCreationDate().getTimeInMillis(), null, f));
                            timestamp = o.getCreationDate().getTimeInMillis();
                        }
                        ++count;
                    }
                    f = this.createResult(CmisTestResultStatus.FAILURE, "No documents starting with '" + c + "' have been found, but there must be at least one!");
                    this.addResult(this.assertIsTrue(count > 0L, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "A page of 10 query hits has been requested, but the repository returned " + count + ".");
                    this.addResult(this.assertIsTrue(count <= 10L, null, f));
                    timestamp = Long.MIN_VALUE;
                    count = 0L;
                    for (CmisObject o : session.queryObjects("cmis:folder", "cmis:name LIKE '" + c + "%'", false, context).getPage(10)) {
                        if (o.getName() == null || o.getName().length() == 0) {
                            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Folder without name should not be returned by this query! Folder ID: " + o.getId()));
                        } else {
                            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder name should start with '" + c + "' but the name is '" + o.getName() + "'.");
                            this.addResult(this.assertEquals(Character.valueOf(c), Character.valueOf(Character.toLowerCase(o.getName().charAt(0))), null, (CmisTestResult)f));
                        }
                        if (o.getCreationDate() == null) {
                            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Found folder without creation date! Folder ID: " + o.getId()));
                        } else {
                            f = this.createResult(CmisTestResultStatus.FAILURE, "Query results should be ordered by cmis:creationDate but they are not!");
                            this.addResult(this.assertIsTrue(timestamp <= o.getCreationDate().getTimeInMillis(), null, f));
                            timestamp = o.getCreationDate().getTimeInMillis();
                        }
                        ++count;
                    }
                    f = this.createResult(CmisTestResultStatus.FAILURE, "No folders starting with '" + c + "' have been found, but there must be at least one!");
                    this.addResult(this.assertIsTrue(count > 0L, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "A page of 10 query hits has been requested, but the repository returned " + count + ".");
                    this.addResult(this.assertIsTrue(count <= 10L, null, f));
                }
            }
            finally {
                this.deleteTestFolder();
            }
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Metadata query not supported. Test Skipped!"));
        }
    }
}

