/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.query;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.QueryStatement;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;
import org.apache.chemistry.opencmis.tck.tests.query.AbstractQueryTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryInFolderTest
extends AbstractQueryTest {
    private static final String CONTENT = "TCK test content.";
    private static final int LEVEL1_DOCS = 5;
    private static final int LEVEL1_FOLDERS = 5;
    private static final int LEVEL2_DOCS = 5;
    private static final int LEVEL2_FOLDERS = 5;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Query IN_FOLDER and IN_TREE Test");
        this.setDescription("Performs IN_FOLDER and IN_TREE queries.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (this.supportsQuery(session) && !this.isFulltextOnly(session)) {
            Folder testFolder = this.createTestFolder(session);
            try {
                int i;
                HashSet<String> topLevelDocs = new HashSet<String>();
                HashSet<String> topLevelFolders = new HashSet<String>();
                for (i = 0; i < 5; ++i) {
                    Document newDocument = this.createDocument(session, testFolder, "doc" + i, CONTENT);
                    topLevelDocs.add(newDocument.getId());
                }
                for (i = 0; i < 5; ++i) {
                    int j;
                    Folder newFolder = this.createFolder(session, testFolder, "folder" + i);
                    topLevelFolders.add(newFolder.getId());
                    for (j = 0; j < 5; ++j) {
                        this.createDocument(session, newFolder, "doc" + j, CONTENT);
                    }
                    for (j = 0; j < 5; ++j) {
                        this.createFolder(session, newFolder, "folder" + j);
                    }
                }
                this.doQuery(session, (ObjectId)testFolder, "cmis:document", false, topLevelDocs, topLevelFolders);
                this.doQuery(session, (ObjectId)testFolder, "cmis:document", true, topLevelDocs, topLevelFolders);
                this.doQuery(session, (ObjectId)testFolder, "cmis:folder", false, topLevelDocs, topLevelFolders);
                this.doQuery(session, (ObjectId)testFolder, "cmis:folder", true, topLevelDocs, topLevelFolders);
            }
            finally {
                this.deleteTestFolder();
            }
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Metadata query not supported. Test Skipped!"));
        }
    }

    private void doQuery(Session session, ObjectId testFolder, String type, boolean deep, Set<String> topLevelDocs, Set<String> topLevelFolders) {
        String inWhat = deep ? "IN_TREE" : "IN_FOLDER";
        QueryStatement statement = session.createQueryStatement("SELECT ? FROM ? WHERE " + inWhat + "(?)");
        statement.setProperty(1, type, "cmis:objectId");
        statement.setType(2, type);
        statement.setString(3, new String[]{testFolder.getId()});
        this.addResult(this.createInfoResult("Query: " + statement.toQueryString()));
        try {
            int count = 0;
            for (QueryResult qr : statement.query(false).getPage(100)) {
                ++count;
                String objectId = (String)qr.getPropertyValueByQueryName("cmis:objectId");
                CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, inWhat + " query returned an invalid object ID!");
                this.addResult(this.assertStringNotEmpty(objectId, null, f));
                FileableCmisObject object = null;
                try {
                    object = (FileableCmisObject)session.getObject(objectId);
                }
                catch (CmisObjectNotFoundException onf) {
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, inWhat + " query returned an object ID of an object that doesn't exist!"));
                }
                if (deep || object == null) continue;
                f = this.createResult(CmisTestResultStatus.FAILURE, inWhat + " query returned an object that should not be there!");
                this.addResult(this.assertIsTrue(topLevelDocs.contains(object.getId()) || topLevelFolders.contains(object.getId()), null, f));
                boolean found = false;
                for (Folder parent : object.getParents()) {
                    if (!testFolder.getId().equals(parent.getId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, inWhat + " query returned an object, which hasn't the test folder as a parent folder!"));
            }
            this.addResult(this.createInfoResult("Hits: " + count));
        }
        catch (CmisBaseException e) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, inWhat + " query failed: " + ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage(), e, false));
        }
    }
}

