/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTreeTest
extends AbstractSessionTest {
    private static final String CONTENT = "TCK test content.";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Delete Tree Test");
        this.setDescription("Creates a few documents in a folder, deletes the folder and checks if all documents are gone.");
    }

    @Override
    public void run(Session session) {
        CmisTestResultImpl f;
        int numOfDocuments = 20;
        Folder testFolder = this.createTestFolder(session);
        HashMap<String, Document> documents = new HashMap<String, Document>();
        for (int i = 0; i < numOfDocuments; ++i) {
            Document newDocument = this.createDocument(session, testFolder, "doc" + i, CONTENT);
            documents.put(newDocument.getId(), newDocument);
        }
        List failedIds = testFolder.deleteTree(true, UnfileObject.DELETE, true);
        if (failedIds != null && failedIds.size() > 0) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "deleteTree() could not delete " + failedIds.size() + " out of " + numOfDocuments + " objects in the folder!");
            this.addResult(this.assertEquals(0, failedIds.size(), null, (CmisTestResult)f));
        }
        for (Document doc : documents.values()) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Document still exists but should have been deleted. Id: " + doc.getId());
            this.addResult(this.assertIsFalse(this.exists((CmisObject)doc), null, f));
        }
        f = this.createResult(CmisTestResultStatus.FAILURE, "Folder still exists but should have been deleted. Id: " + testFolder.getId());
        this.addResult(this.assertIsFalse(this.exists((CmisObject)testFolder), null, f));
        if (this.exists((CmisObject)testFolder)) {
            this.deleteObject((CmisObject)testFolder);
        }
    }
}

